/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.secstruc;

import java.io.Serializable;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.ResidueRangeAndLength;
import org.biojava.nbio.structure.secstruc.SecStrucType;

public class SecStrucElement
implements Serializable {
    private static final long serialVersionUID = -8485685793171396131L;
    private final SecStrucType type;
    private final ResidueRangeAndLength range;
    private final int index;

    public SecStrucElement(SecStrucType type, ResidueNumber start, ResidueNumber end, int length, int index, String chainID) {
        this.type = type;
        this.index = index;
        this.range = new ResidueRangeAndLength(chainID, start, end, length);
    }

    public SecStrucType getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.range.getLength();
    }

    public String getId() {
        return this.type.toString() + this.index + "";
    }

    public ResidueRangeAndLength getRange() {
        return this.range;
    }

    public String toString() {
        return this.getId() + ": " + this.range.toString();
    }
}

