/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.scop;

import java.net.URI;
import java.net.URISyntaxException;
import org.biojava.nbio.core.util.FileDownloadUtils;

public class ScopMirror {
    private String rootURL = null;
    private final String claURL;
    private final String desURL;
    private final String hieURL;
    private final String comURL;

    public ScopMirror(String claURL, String desURL, String hieURL, String comURL) {
        this.claURL = claURL;
        this.desURL = desURL;
        this.hieURL = hieURL;
        this.comURL = comURL;
    }

    public ScopMirror(String url, String claURL, String desURL, String hieURL, String comURL) {
        this(url + claURL, url + desURL, url + hieURL, url + comURL);
        this.rootURL = url;
    }

    public ScopMirror(String url) {
        this(url, "dir.cla.scop.txt_%s", "dir.des.scop.txt_%s", "dir.hie.scop.txt_%s", "dir.com.scop.txt_%s");
    }

    public ScopMirror() {
        this("http://scop.berkeley.edu/downloads/parse/");
    }

    public String getRootURL() {
        return this.rootURL;
    }

    public String getClaURL(String scopVersion) {
        return String.format(this.claURL, scopVersion);
    }

    public String getDesURL(String scopVersion) {
        return String.format(this.desURL, scopVersion);
    }

    public String getHieURL(String scopVersion) {
        return String.format(this.hieURL, scopVersion);
    }

    public String getComURL(String scopVersion) {
        return String.format(this.comURL, scopVersion);
    }

    public boolean isReachable() {
        int timeout = 800;
        if (this.rootURL != null) {
            return FileDownloadUtils.ping((String)this.getRootURL(), (int)800);
        }
        try {
            URI cla = new URI(this.getClaURL("VERSION"));
            String host = cla.getHost();
            return FileDownloadUtils.ping((String)host, (int)800);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

