/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.IOException;
import java.io.InputStream;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.io.cif.CifStructureConverter;

public class CifFileReader
extends LocalPDBDirectory {
    public static final String[] CIF_SPLIT_DIR = new String[]{"data", "structures", "divided", "mmCIF"};
    public static final String[] CIF_OBSOLETE_DIR = new String[]{"data", "structures", "obsolete", "mmCIF"};

    public CifFileReader() {
        this(null);
    }

    public CifFileReader(String path) {
        super(path);
        this.addExtension(".cif");
        this.addExtension(".mmcif");
        this.addExtension(".cif.gz");
        this.addExtension(".mmcif.gz");
    }

    @Override
    public Structure getStructure(InputStream inStream) throws IOException {
        return CifStructureConverter.fromInputStream(inStream, this.getFileParsingParameters());
    }

    @Override
    protected String getFilename(String pdbId) {
        return pdbId.toLowerCase() + ".cif.gz";
    }

    @Override
    protected String[] getSplitDirPath() {
        return CIF_SPLIT_DIR;
    }

    @Override
    protected String[] getObsoleteDirPath() {
        return CIF_OBSOLETE_DIR;
    }
}

