/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.chem;

import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.structure.chem.ChemComp;

public class ChemicalComponentDictionary {
    private final Map<String, ChemComp> dictionary = new HashMap<String, ChemComp>();
    private final Map<String, String> replaces = new HashMap<String, String>();
    private final Map<String, String> isReplacedBy = new HashMap<String, String>();

    public boolean isReplaced(ChemComp c) {
        return this.isReplaced(c.getId());
    }

    public boolean isReplaced(String id) {
        return this.isReplacedBy.containsKey(id);
    }

    public boolean isReplacer(ChemComp c) {
        return this.isReplacer(c.getId());
    }

    public boolean isReplacer(String id) {
        return this.replaces.containsKey(id);
    }

    public ChemComp getReplacer(ChemComp c) {
        return this.getReplacer(c.getId());
    }

    public ChemComp getReplacer(String id) {
        if (this.isReplaced(id)) {
            return this.dictionary.get(this.isReplacedBy.get(id));
        }
        return this.dictionary.get(id);
    }

    public ChemComp getReplaced(ChemComp c) {
        return this.getReplaced(c.getId());
    }

    public ChemComp getReplaced(String id) {
        if (this.isReplacer(id)) {
            return this.dictionary.get(this.replaces.get(id));
        }
        return this.dictionary.get(id);
    }

    public ChemComp getParent(ChemComp c) {
        if (c.hasParent()) {
            return this.dictionary.get(c.getMonNstdParentCompId());
        }
        return null;
    }

    public void addChemComp(ChemComp comp) {
        String isrep;
        this.dictionary.put(comp.getId(), comp);
        String rep = comp.getPdbxReplaces();
        if (rep != null && !rep.equals("?")) {
            this.replaces.put(comp.getId(), rep);
        }
        if ((isrep = comp.getPdbxReplacedBy()) != null && !isrep.equals("?")) {
            this.isReplacedBy.put(comp.getId(), isrep);
        }
    }

    public int size() {
        return this.dictionary.size();
    }

    public ChemComp getChemComp(String id) {
        return this.dictionary.get(id);
    }
}

