/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.structure.PdbId;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIO;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.biojava.nbio.structure.io.StructureFiletype;
import org.biojava.nbio.structure.io.cif.CifStructureConverter;
import org.biojava.nbio.structure.io.mmtf.MmtfActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLIdentifier
implements StructureIdentifier {
    private static final long serialVersionUID = -5161230822868926035L;
    private static final Logger logger = LoggerFactory.getLogger(URLIdentifier.class);
    private static final Pattern PDBID_REGEX = Pattern.compile("^(?:pdb)?([0-9][a-z0-9]{3})([._-]|\\s).*", 2);
    public static final String FORMAT_PARAM = "format";
    public static final String PDBID_PARAM = "pdbid";
    public static final String CHAINID_PARAM = "chainid";
    public static final String RESIDUES_PARAM = "residues";
    private final URL url;

    public URLIdentifier(URL url) {
        this.url = url;
    }

    public URLIdentifier(String url) throws MalformedURLException {
        this(new URL(url));
    }

    public URL getURL() {
        return this.url;
    }

    @Override
    public String getIdentifier() {
        return this.url.toString();
    }

    @Override
    public SubstructureIdentifier toCanonical() throws StructureException {
        String pdbId = null;
        List<ResidueRange> ranges = Collections.emptyList();
        try {
            Map<String, String> params = URLIdentifier.parseQuery(this.url);
            if (params.containsKey(PDBID_PARAM)) {
                pdbId = params.get(PDBID_PARAM);
            }
            if (params.containsKey(RESIDUES_PARAM)) {
                ranges = ResidueRange.parseMultiple(params.get(RESIDUES_PARAM));
            } else if (params.containsKey(CHAINID_PARAM)) {
                ranges = Collections.singletonList(new ResidueRange(params.get(CHAINID_PARAM), (ResidueNumber)null, (ResidueNumber)null));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Unable to decode URL {}", (Object)this.url, (Object)e);
        }
        if (pdbId == null) {
            String path = this.url.getPath();
            pdbId = URLIdentifier.guessPDBID(path.substring(path.lastIndexOf("/") + 1));
        }
        return new SubstructureIdentifier(pdbId == null ? (PdbId)null : new PdbId(pdbId), ranges);
    }

    @Override
    public Structure reduce(Structure input) throws StructureException {
        return this.toCanonical().reduce(input);
    }

    @Override
    public Structure loadStructure(AtomCache cache) throws StructureException, IOException {
        StructureFiletype format = StructureFiletype.UNKNOWN;
        try {
            Map<String, String> params = URLIdentifier.parseQuery(this.url);
            if (params.containsKey(FORMAT_PARAM)) {
                String formatStr = params.get(FORMAT_PARAM);
                format = StructureIO.guessFiletype("." + formatStr);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Unable to decode URL {}", (Object)this.url, (Object)e);
        }
        if (format == StructureFiletype.UNKNOWN) {
            format = StructureIO.guessFiletype(this.url.getPath());
        }
        switch (format) {
            case CIF: 
            case BCIF: {
                return CifStructureConverter.fromURL(this.url, cache.getFileParsingParams());
            }
            case MMTF: {
                return MmtfActions.readFromInputStream(this.url.openStream());
            }
        }
        PDBFileReader reader = new PDBFileReader(cache.getPath());
        reader.setFetchBehavior(cache.getFetchBehavior());
        reader.setObsoleteBehavior(cache.getObsoleteBehavior());
        reader.setFileParsingParameters(cache.getFileParsingParams());
        return reader.getStructure(this.url);
    }

    public static String guessPDBID(String name) {
        Matcher match = PDBID_REGEX.matcher(name);
        if (match.matches()) {
            return match.group(1).toUpperCase();
        }
        return null;
    }

    private static Map<String, String> parseQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        String query = url.getQuery();
        if (query == null || query.isEmpty()) {
            return params;
        }
        for (String pair : pairs = url.getQuery().split("&")) {
            int i = pair.indexOf("=");
            String key = pair;
            if (i > 0) {
                key = URLDecoder.decode(pair.substring(0, i), "UTF-8");
            }
            String value = null;
            if (i > 0 && pair.length() > i + 1) {
                value = URLDecoder.decode(pair.substring(i + 1), "UTF-8");
            }
            params.put(key.toLowerCase(), value);
        }
        return params;
    }
}

