/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.xtal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class CrystalCell
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final double MIN_VALID_CELL_SIZE = 10.0;
    private double a;
    private double b;
    private double c;
    private double alpha;
    private double beta;
    private double gamma;
    private double alphaRad;
    private double betaRad;
    private double gammaRad;
    private double volume;
    private double maxDimension;
    private Matrix3d M;
    private Matrix3d Minv;
    private Matrix3d Mtransp;
    private Matrix3d MtranspInv;

    public CrystalCell() {
    }

    public CrystalCell(double a, double b, double c, double alpha, double beta, double gamma) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.setAlpha(alpha);
        this.setBeta(beta);
        this.setGamma(gamma);
    }

    public double getA() {
        return this.a;
    }

    public void setA(double a) {
        this.a = a;
    }

    public double getB() {
        return this.b;
    }

    public void setB(double b) {
        this.b = b;
    }

    public double getC() {
        return this.c;
    }

    public void setC(double c) {
        this.c = c;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
        this.alphaRad = Math.toRadians(alpha);
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double beta) {
        this.beta = beta;
        this.betaRad = Math.toRadians(beta);
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
        this.gammaRad = Math.toRadians(gamma);
    }

    public double getVolume() {
        if (this.volume != 0.0) {
            return this.volume;
        }
        this.volume = this.a * this.b * this.c * Math.sqrt(1.0 - Math.cos(this.alphaRad) * Math.cos(this.alphaRad) - Math.cos(this.betaRad) * Math.cos(this.betaRad) - Math.cos(this.gammaRad) * Math.cos(this.gammaRad) + 2.0 * Math.cos(this.alphaRad) * Math.cos(this.betaRad) * Math.cos(this.gammaRad));
        return this.volume;
    }

    public Point3i getCellIndices(Tuple3d pt) {
        Point3d p = new Point3d(pt);
        this.transfToCrystal((Tuple3d)p);
        int x = (int)Math.floor(p.x);
        int y = (int)Math.floor(p.y);
        int z = (int)Math.floor(p.z);
        return new Point3i(x, y, z);
    }

    public void transfToOriginCell(Tuple3d pt) {
        this.transfToCrystal(pt);
        pt.x = pt.x < 0.0 ? (pt.x % 1.0 + 1.0) % 1.0 : pt.x % 1.0;
        pt.y = pt.y < 0.0 ? (pt.y % 1.0 + 1.0) % 1.0 : pt.y % 1.0;
        pt.z = pt.z < 0.0 ? (pt.z % 1.0 + 1.0) % 1.0 : pt.z % 1.0;
        this.transfToOrthonormal(pt);
    }

    public void transfToOriginCell(Tuple3d[] points, Tuple3d reference) {
        reference = new Point3d(reference);
        this.transfToCrystal(reference);
        int x = (int)Math.floor(reference.x);
        int y = (int)Math.floor(reference.y);
        int z = (int)Math.floor(reference.z);
        for (Tuple3d point : points) {
            this.transfToCrystal(point);
            point.x -= (double)x;
            point.y -= (double)y;
            point.z -= (double)z;
            this.transfToOrthonormal(point);
        }
    }

    public Matrix4d[] transfToOriginCellOrthonormal(Matrix4d[] ops, Tuple3d reference) {
        Point3d refXtal = new Point3d(reference);
        this.transfToCrystal((Tuple3d)refXtal);
        Matrix4d[] opsXtal = new Matrix4d[ops.length];
        for (int i = 0; i < ops.length; ++i) {
            opsXtal[i] = this.transfToCrystal(ops[i]);
        }
        Matrix4d[] transformed = this.transfToOriginCellCrystal(opsXtal, (Tuple3d)refXtal);
        for (int i = 0; i < ops.length; ++i) {
            transformed[i] = this.transfToOrthonormal(transformed[i]);
        }
        return transformed;
    }

    public Matrix4d[] transfToOriginCellCrystal(Matrix4d[] ops, Tuple3d reference) {
        Matrix4d[] transformed = new Matrix4d[ops.length];
        for (int j = 0; j < ops.length; ++j) {
            Matrix4d op = ops[j];
            Point3d xXtal = new Point3d(reference);
            op.transform(xXtal);
            int x = (int)Math.floor(xXtal.x);
            int y = (int)Math.floor(xXtal.y);
            int z = (int)Math.floor(xXtal.z);
            Matrix4d translation = new Matrix4d();
            translation.set(new Vector3d((double)(-x), (double)(-y), (double)(-z)));
            translation.mul(op);
            Point3d ref2 = new Point3d(reference);
            translation.transform(ref2);
            transformed[j] = translation;
        }
        return transformed;
    }

    public Matrix4d transfToOrthonormal(Matrix4d m) {
        Vector3d trans = new Vector3d(m.m03, m.m13, m.m23);
        this.transfToOrthonormal((Tuple3d)trans);
        Matrix3d rot = new Matrix3d();
        m.getRotationScale(rot);
        rot.mul(this.getMTranspose());
        rot.mul(this.getMTransposeInv(), rot);
        return new Matrix4d(rot, trans, 1.0);
    }

    public void transfToOrthonormal(Tuple3d v) {
        this.getMTransposeInv().transform(v);
    }

    public Matrix4d transfToCrystal(Matrix4d m) {
        Vector3d trans = new Vector3d(m.m03, m.m13, m.m23);
        this.transfToCrystal((Tuple3d)trans);
        Matrix3d rot = new Matrix3d();
        m.getRotationScale(rot);
        rot.mul(this.getMTransposeInv());
        rot.mul(this.getMTranspose(), rot);
        return new Matrix4d(rot, trans, 1.0);
    }

    public void transfToCrystal(Tuple3d v) {
        this.getMTranspose().transform(v);
    }

    private Matrix3d getMInv() {
        if (this.Minv != null) {
            return this.Minv;
        }
        this.Minv = new Matrix3d(this.a, 0.0, 0.0, this.b * Math.cos(this.gammaRad), this.b * Math.sin(this.gammaRad), 0.0, this.c * Math.cos(this.betaRad), -this.c * Math.sin(this.betaRad) * this.getCosAlphaStar(), 1.0 / this.getCstar());
        return this.Minv;
    }

    private double getAstar() {
        return this.b * this.c * Math.sin(this.alphaRad) / this.getVolume();
    }

    private double getBstar() {
        return this.a * this.c * Math.sin(this.betaRad) / this.getVolume();
    }

    private double getCstar() {
        return this.a * this.b * Math.sin(this.gammaRad) / this.getVolume();
    }

    private double getCosAlphaStar() {
        return (Math.cos(this.betaRad) * Math.cos(this.gammaRad) - Math.cos(this.alphaRad)) / (Math.sin(this.betaRad) * Math.sin(this.gammaRad));
    }

    private double getCosBetaStar() {
        return (Math.cos(this.alphaRad) * Math.cos(this.gammaRad) - Math.cos(this.betaRad)) / (Math.sin(this.alphaRad) * Math.sin(this.gammaRad));
    }

    private double getCosGammaStar() {
        return (Math.cos(this.alphaRad) * Math.cos(this.betaRad) - Math.cos(this.gammaRad)) / (Math.sin(this.alphaRad) * Math.sin(this.betaRad));
    }

    private double getSinAlphaStar() {
        return this.getVolume() / (this.a * this.b * this.c * Math.sin(this.betaRad) * Math.sin(this.gammaRad));
    }

    private double getSinBetaStar() {
        return this.getVolume() / (this.a * this.b * this.c * Math.sin(this.alphaRad) * Math.sin(this.gammaRad));
    }

    private double getSinGammaStar() {
        return this.getVolume() / (this.a * this.b * this.c * Math.sin(this.alphaRad) * Math.sin(this.betaRad));
    }

    private Matrix3d getM() {
        if (this.M != null) {
            return this.M;
        }
        this.M = new Matrix3d();
        this.M.invert(this.getMInv());
        return this.M;
    }

    public Matrix3d getMTranspose() {
        if (this.Mtransp != null) {
            return this.Mtransp;
        }
        Matrix3d M = this.getM();
        this.Mtransp = new Matrix3d();
        this.Mtransp.transpose(M);
        return this.Mtransp;
    }

    private Matrix3d getMTransposeInv() {
        if (this.MtranspInv != null) {
            return this.MtranspInv;
        }
        this.MtranspInv = new Matrix3d();
        this.MtranspInv.invert(this.getMTranspose());
        return this.MtranspInv;
    }

    public double getMaxDimension() {
        if (this.maxDimension != 0.0) {
            return this.maxDimension;
        }
        Point3d vert0 = new Point3d(0.0, 0.0, 0.0);
        Point3d vert1 = new Point3d(1.0, 0.0, 0.0);
        this.transfToOrthonormal((Tuple3d)vert1);
        Point3d vert2 = new Point3d(0.0, 1.0, 0.0);
        this.transfToOrthonormal((Tuple3d)vert2);
        Point3d vert3 = new Point3d(0.0, 0.0, 1.0);
        this.transfToOrthonormal((Tuple3d)vert3);
        Point3d vert4 = new Point3d(1.0, 1.0, 0.0);
        this.transfToOrthonormal((Tuple3d)vert4);
        Point3d vert5 = new Point3d(1.0, 0.0, 1.0);
        this.transfToOrthonormal((Tuple3d)vert5);
        Point3d vert6 = new Point3d(0.0, 1.0, 1.0);
        this.transfToOrthonormal((Tuple3d)vert6);
        Point3d vert7 = new Point3d(1.0, 1.0, 1.0);
        this.transfToOrthonormal((Tuple3d)vert7);
        ArrayList<Double> vertDists = new ArrayList<Double>();
        vertDists.add(vert0.distance(vert7));
        vertDists.add(vert3.distance(vert4));
        vertDists.add(vert1.distance(vert6));
        vertDists.add(vert2.distance(vert5));
        this.maxDimension = (Double)Collections.max(vertDists);
        return this.maxDimension;
    }

    public boolean checkScaleMatrixConsistency(Matrix4d scaleMatrix) {
        double vol = this.getVolume();
        Matrix3d m = new Matrix3d();
        scaleMatrix.getRotationScale(m);
        double tolerance = vol / 100.0;
        return !(Math.abs(vol - 1.0 / m.determinant()) > tolerance);
    }

    public boolean checkScaleMatrix(Matrix4d scaleMatrix) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.deltaComp(this.getMTranspose().getElement(i, j), scaleMatrix.getElement(i, j))) continue;
                return false;
            }
        }
        for (i = 0; i < 3; ++i) {
            if (this.deltaComp(scaleMatrix.getElement(i, 3), 0.0)) continue;
            return false;
        }
        return true;
    }

    private boolean deltaComp(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-4;
    }

    public boolean isCellReasonable() {
        return !(this.getA() < 10.0) || !(this.getB() < 10.0) || !(this.getC() < 10.0);
    }

    public String toString() {
        return String.format("a%7.2f b%7.2f c%7.2f alpha%6.2f beta%6.2f gamma%6.2f", this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
    }
}

