/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.xtal;

import java.util.ArrayList;
import java.util.Iterator;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.contact.AtomContactSet;
import org.biojava.nbio.structure.contact.StructureInterface;
import org.biojava.nbio.structure.contact.StructureInterfaceList;
import org.biojava.nbio.structure.xtal.CrystalTransform;
import org.biojava.nbio.structure.xtal.UnitCellBoundingBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrystalBuilder {
    public static final int DEF_NUM_CELLS = 12;
    public static final double DEFAULT_INTERFACE_DISTANCE_CUTOFF = 5.5;
    public static final Matrix4d IDENTITY = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    private static final boolean INCLUDE_HETATOMS = true;
    private Structure structure;
    private PDBCrystallographicInfo crystallographicInfo;
    private int numChainsAu;
    private int numOperatorsSg;
    private static final Logger logger = LoggerFactory.getLogger(CrystalBuilder.class);
    private int numCells;
    private ArrayList<CrystalTransform> visited;
    private boolean isCrystallographic;

    public CrystalBuilder(Structure structure) {
        this.structure = structure;
        this.crystallographicInfo = structure.getCrystallographicInfo();
        this.numChainsAu = structure.getChains().size();
        this.numOperatorsSg = 1;
        if (structure.isCrystallographic()) {
            this.isCrystallographic = true;
            if (this.crystallographicInfo.getSpaceGroup() == null) {
                logger.warn("Could not find a space group, will only calculate asymmetric unit interfaces.");
                this.isCrystallographic = false;
            } else {
                this.numOperatorsSg = this.crystallographicInfo.getSpaceGroup().getMultiplicity();
            }
            if (this.crystallographicInfo.getCrystalCell() == null) {
                logger.warn("Could not find a crystal cell definition, will only calculate asymmetric unit interfaces.");
                this.isCrystallographic = false;
            }
        } else {
            this.isCrystallographic = false;
        }
        this.numCells = 12;
    }

    public void setNumCells(int numCells) {
        this.numCells = numCells;
    }

    private void initialiseVisited() {
        this.visited = new ArrayList();
    }

    public StructureInterfaceList getUniqueInterfaces() {
        return this.getUniqueInterfaces(5.5);
    }

    public StructureInterfaceList getUniqueInterfaces(double cutoff) {
        StructureInterfaceList set = new StructureInterfaceList();
        if (this.structure.getChains().size() == 0) {
            logger.warn("No chains present in the structure! No interfaces will be calculated");
            return set;
        }
        this.initialiseVisited();
        this.calcInterfacesCrystal(set, cutoff);
        return set;
    }

    private void calcInterfacesCrystal(StructureInterfaceList set, double cutoff) {
        boolean verbose;
        long start = -1L;
        long end = -1L;
        int trialCount = 0;
        int skippedRedundant = 0;
        int skippedAUsNoOverlap = 0;
        int skippedChainsNoOverlap = 0;
        int skippedSelfEquivalent = 0;
        Matrix4d[] ops = null;
        ops = this.isCrystallographic ? this.structure.getCrystallographicInfo().getTransformationsOrthonormal() : new Matrix4d[]{new Matrix4d(IDENTITY)};
        UnitCellBoundingBox bbGrid = new UnitCellBoundingBox(this.numOperatorsSg, this.numChainsAu);
        bbGrid.setBbs(this.structure, ops, true);
        if (!this.isCrystallographic) {
            this.numCells = 0;
        }
        if (verbose = logger.isDebugEnabled()) {
            trialCount = 0;
            start = System.currentTimeMillis();
            int neighbors = (2 * this.numCells + 1) * (2 * this.numCells + 1) * (2 * this.numCells + 1) - 1;
            int auTrials = this.numChainsAu * (this.numChainsAu - 1) / 2;
            int trials = this.numChainsAu * this.numOperatorsSg * this.numChainsAu * neighbors;
            logger.debug("Chain clash trials within original AU: " + auTrials);
            logger.debug("Chain clash trials between the original AU and the neighbouring " + neighbors + " whole unit cells (" + this.numCells + " neighbours)" + "(2x" + this.numChainsAu + "chains x " + this.numOperatorsSg + "AUs x " + neighbors + "cells) : " + trials);
            logger.debug("Total trials: " + (auTrials + trials));
        }
        for (int a = -this.numCells; a <= this.numCells; ++a) {
            for (int b = -this.numCells; b <= this.numCells; ++b) {
                for (int c = -this.numCells; c <= this.numCells; ++c) {
                    Point3i trans = new Point3i(a, b, c);
                    Vector3d transOrth = new Vector3d((double)a, (double)b, (double)c);
                    if (a != 0 || b != 0 || c != 0) {
                        this.crystallographicInfo.getCrystalCell().transfToOrthonormal((Tuple3d)transOrth);
                    }
                    UnitCellBoundingBox bbGridTrans = bbGrid.getTranslatedBbs(transOrth);
                    for (int n = 0; n < this.numOperatorsSg; ++n) {
                        if (!bbGrid.getAuBoundingBox(0).overlaps(bbGridTrans.getAuBoundingBox(n), cutoff)) {
                            ++skippedAUsNoOverlap;
                            continue;
                        }
                        CrystalTransform tt = new CrystalTransform(this.crystallographicInfo.getSpaceGroup(), n);
                        tt.translate(trans);
                        if (this.isRedundant(tt)) {
                            ++skippedRedundant;
                            continue;
                        }
                        this.addVisited(tt);
                        boolean selfEquivalent = false;
                        if (tt.isEquivalent(tt)) {
                            logger.debug("Transform " + tt + " is equivalent to itself, will skip half of i-chains to j-chains comparisons");
                            selfEquivalent = true;
                        }
                        StringBuilder builder = null;
                        if (verbose) {
                            builder = new StringBuilder(tt + " ");
                        }
                        int contactsFound = 0;
                        for (int j = 0; j < this.numChainsAu; ++j) {
                            for (int i = 0; i < this.numChainsAu; ++i) {
                                if (selfEquivalent && j > i) {
                                    ++skippedSelfEquivalent;
                                    continue;
                                }
                                if (n == 0 && a == 0 && b == 0 && c == 0 && i == j) continue;
                                if (!bbGrid.getChainBoundingBox(0, i).overlaps(bbGridTrans.getChainBoundingBox(n, j), cutoff)) {
                                    ++skippedChainsNoOverlap;
                                    if (!verbose) continue;
                                    builder.append(".");
                                    continue;
                                }
                                ++trialCount;
                                Chain chainj = null;
                                Chain chaini = this.structure.getChain(i);
                                if (n == 0 && a == 0 && b == 0 && c == 0) {
                                    chainj = this.structure.getChain(j);
                                } else {
                                    chainj = (Chain)this.structure.getChain(j).clone();
                                    Matrix4d m = new Matrix4d(ops[n]);
                                    this.translate(m, transOrth);
                                    Calc.transform(chainj, m);
                                }
                                StructureInterface interf = this.calcContacts(chaini, chainj, cutoff, tt, builder);
                                if (interf == null) continue;
                                ++contactsFound;
                                set.add(interf);
                            }
                        }
                        if (!verbose) continue;
                        if (a == 0 && b == 0 && c == 0 && n == 0) {
                            builder.append(" " + contactsFound + "(" + this.numChainsAu * (this.numChainsAu - 1) / 2 + ")");
                        } else if (selfEquivalent) {
                            builder.append(" " + contactsFound + "(" + this.numChainsAu * (this.numChainsAu + 1) / 2 + ")");
                        } else {
                            builder.append(" " + contactsFound + "(" + this.numChainsAu * this.numChainsAu + ")");
                        }
                        logger.debug(builder.toString());
                    }
                }
            }
        }
        end = System.currentTimeMillis();
        logger.debug("\n" + trialCount + " chain-chain clash trials done. Time " + (end - start) / 1000L + "s");
        logger.debug("  skipped (not overlapping AUs)       : " + skippedAUsNoOverlap);
        logger.debug("  skipped (not overlapping chains)    : " + skippedChainsNoOverlap);
        logger.debug("  skipped (sym redundant op pairs)    : " + skippedRedundant);
        logger.debug("  skipped (sym redundant self op)     : " + skippedSelfEquivalent);
        logger.debug("Found " + set.size() + " interfaces.");
    }

    private StructureInterface calcContacts(Chain chaini, Chain chainj, double cutoff, CrystalTransform tt, StringBuilder builder) {
        AtomContactSet graph = StructureTools.getAtomsInContact(chaini, chainj, cutoff, true);
        if (graph.size() > 0) {
            if (builder != null) {
                builder.append("x");
            }
            CrystalTransform transf = new CrystalTransform(this.crystallographicInfo.getSpaceGroup());
            StructureInterface interf = new StructureInterface(StructureTools.getAllAtomArray(chaini), StructureTools.getAllAtomArray(chainj), chaini.getChainID(), chainj.getChainID(), graph, transf, tt);
            return interf;
        }
        if (builder != null) {
            builder.append("o");
        }
        return null;
    }

    private void addVisited(CrystalTransform tt) {
        this.visited.add(tt);
    }

    private boolean isRedundant(CrystalTransform tt) {
        Iterator<CrystalTransform> it = this.visited.iterator();
        while (it.hasNext()) {
            CrystalTransform v = it.next();
            if (!tt.isEquivalent(v)) continue;
            logger.debug("Skipping redundant transformation: " + tt + ", equivalent to " + v);
            it.remove();
            return true;
        }
        return false;
    }

    public void translate(Matrix4d m, Vector3d translation) {
        m.m03 += translation.x;
        m.m13 += translation.y;
        m.m23 += translation.z;
    }
}

