/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.geometry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;

public class DistanceBox<T> {
    private Map<Long, List<T>> map;
    private Map<Long, List<T>> layerMap;
    private boolean modified;
    private double inverseBinWidth;
    private static final long[] offset = new long[]{0L, -1000010001L, -10001L, 999989999L, -1000000001L, -1L, 999999999L, -999990001L, 9999L, 1000009999L, -1000010000L, -10000L, 999990000L, -1000000000L, 1000000000L, -999990000L, 10000L, 1000010000L, -1000009999L, -9999L, 999990001L, -999999999L, 1L, 1000000001L, -999989999L, 10001L, 1000010001L};
    private List<T> tempBox = new ArrayList<T>(offset.length);

    public DistanceBox(double binWidth) {
        this.map = new HashMap<Long, List<T>>();
        this.layerMap = new HashMap<Long, List<T>>();
        this.inverseBinWidth = 1.0 / binWidth;
        this.modified = true;
    }

    public void addPoint(Point3d point, T object) {
        long k;
        long j;
        long i = (long)StrictMath.rint(point.x * this.inverseBinWidth);
        long location = i + (j = (long)StrictMath.rint(point.y * this.inverseBinWidth)) * 10000L + (k = (long)StrictMath.rint(point.z * this.inverseBinWidth)) * 1000000000L;
        List<T> box = this.map.get(location);
        if (box == null) {
            box = new ArrayList<T>();
            this.map.put(location, box);
        }
        box.add(object);
        this.modified = true;
    }

    public List<T> getNeighborsWithCache(Point3d point) {
        long k;
        long j;
        long i;
        long location;
        List<T> box;
        if (this.modified) {
            this.layerMap.clear();
            this.modified = false;
        }
        if ((box = this.layerMap.get(location = (i = (long)StrictMath.rint(point.x * this.inverseBinWidth)) + (j = (long)StrictMath.rint(point.y * this.inverseBinWidth)) * 10000L + (k = (long)StrictMath.rint(point.z * this.inverseBinWidth)) * 1000000000L)) == null) {
            box = this.getBoxTwo(location);
            this.layerMap.put(location, box);
        }
        return box;
    }

    public List<T> getNeighbors(Point3d point) {
        if (this.modified) {
            this.layerMap.clear();
            this.modified = false;
        }
        long i = (long)StrictMath.rint(point.x * this.inverseBinWidth);
        long j = (long)StrictMath.rint(point.y * this.inverseBinWidth);
        long k = (long)StrictMath.rint(point.z * this.inverseBinWidth);
        long location = i + j * 10000L + k * 1000000000L;
        List<T> box = this.getBoxTwo(location);
        return box;
    }

    public List<T> getIntersection(DistanceBox<T> distanceBox) {
        ArrayList intersection = new ArrayList();
        HashSet<Long> checkedLocations = new HashSet<Long>();
        for (long location : this.map.keySet()) {
            long loc;
            int i;
            boolean overlap = false;
            int n = offset.length;
            for (i = 0; i < n; ++i) {
                loc = location + offset[i];
                if (!super.contains(loc)) continue;
                overlap = true;
                break;
            }
            if (!overlap) continue;
            n = offset.length;
            for (i = 0; i < n; ++i) {
                loc = location + offset[i];
                if (checkedLocations.contains(loc)) continue;
                checkedLocations.add(loc);
                if (!this.contains(loc)) continue;
                intersection.addAll(this.map.get(loc));
            }
        }
        return intersection;
    }

    private List<T> getBoxTwo(long location) {
        this.tempBox.clear();
        int n = offset.length;
        for (int i = 0; i < n; ++i) {
            List<T> box = this.map.get(location + offset[i]);
            if (box == null) continue;
            this.tempBox.addAll(box);
        }
        List boxTwo = null;
        boxTwo = this.tempBox.size() == 0 ? Collections.emptyList() : (this.tempBox.size() == 1 ? Collections.singletonList(this.tempBox.get(0)) : new ArrayList<T>(this.tempBox));
        return boxTwo;
    }

    private boolean contains(long location) {
        return this.map.containsKey(location);
    }
}

