/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.scop;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.align.client.JFatCatClient;
import org.biojava.nbio.structure.align.util.HTTPConnectionTools;
import org.biojava.nbio.structure.domain.SerializableCache;
import org.biojava.nbio.structure.scop.RemoteScopInstallation;
import org.biojava.nbio.structure.scop.ScopCategory;
import org.biojava.nbio.structure.scop.ScopDatabase;
import org.biojava.nbio.structure.scop.ScopDescription;
import org.biojava.nbio.structure.scop.ScopDomain;
import org.biojava.nbio.structure.scop.ScopNode;
import org.biojava.nbio.structure.scop.server.ScopDomains;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedRemoteScopInstallation
extends SerializableCache<String, ScopDomain>
implements ScopDatabase {
    private static final Logger logger = LoggerFactory.getLogger(CachedRemoteScopInstallation.class);
    private static final String CACHE_FILE_NAME = "remotescopinstallation.ser";
    RemoteScopInstallation proxy = new RemoteScopInstallation();
    SerializableCache<Integer, ScopDescription> scopDescriptionCache = new SerializableCache("scopDescriptionCache.ser");

    public CachedRemoteScopInstallation() throws IOException {
        this(true);
    }

    public CachedRemoteScopInstallation(boolean useCache) throws IOException {
        super(CACHE_FILE_NAME);
        if (!useCache) {
            logger.warn(this.getClass().getSimpleName() + " disabling cache");
            this.disableCache();
            this.scopDescriptionCache.disableCache();
        } else if (this.serializedCache.size() < 8000) {
            this.loadRepresentativeDomains();
        }
    }

    private void loadRepresentativeDomains() throws IOException {
        URL u = null;
        try {
            u = new URL("http://source.rcsb.org/jfatcatserver/domains/getRepresentativeScopDomains");
        }
        catch (MalformedURLException e) {
            throw new IOException("URL http://source.rcsb.org/jfatcatserver/domains/getRepresentativeScopDomains is wrong", e);
        }
        logger.info("Using " + u + " to download representative domains");
        InputStream response = HTTPConnectionTools.getInputStream(u);
        String xml = JFatCatClient.convertStreamToString(response);
        ScopDomains results = ScopDomains.fromXML(xml);
        logger.info("got " + results.getScopDomain().size() + " domain ranges for Scop domains from server.");
        for (ScopDomain dom : results.getScopDomain()) {
            String scopId = dom.getScopId();
            this.serializedCache.put(scopId, dom);
        }
    }

    @Override
    public List<ScopDescription> getByCategory(ScopCategory category) {
        return this.proxy.getByCategory(category);
    }

    @Override
    public List<ScopDescription> filterByClassificationId(String query) {
        return this.proxy.filterByClassificationId(query);
    }

    @Override
    public List<ScopNode> getTree(ScopDomain domain) {
        return this.proxy.getTree(domain);
    }

    @Override
    public List<ScopDomain> filterByDomainName(String query) {
        return this.proxy.filterByDomainName(query);
    }

    @Override
    public List<ScopDescription> filterByDescription(String query) {
        return this.proxy.filterByClassificationId(query);
    }

    @Override
    public ScopDescription getScopDescriptionBySunid(int sunid) {
        ScopDescription desc = this.scopDescriptionCache.get(sunid);
        if (desc != null) {
            return desc;
        }
        desc = this.proxy.getScopDescriptionBySunid(sunid);
        if (desc != null) {
            this.scopDescriptionCache.cache(sunid, desc);
        }
        return desc;
    }

    @Override
    public List<ScopDomain> getDomainsForPDB(String pdbId) {
        return this.proxy.getDomainsForPDB(pdbId);
    }

    @Override
    public ScopDomain getDomainByScopID(String scopId) {
        ScopDomain dom;
        if (this.serializedCache != null && this.serializedCache.containsKey(scopId) && (dom = (ScopDomain)this.serializedCache.get(scopId)) != null) {
            return dom;
        }
        dom = this.proxy.getDomainByScopID(scopId);
        if (dom != null) {
            this.cache(scopId, dom);
        }
        return dom;
    }

    @Override
    public ScopNode getScopNode(int sunid) {
        return this.proxy.getScopNode(sunid);
    }

    @Override
    public String getScopVersion() {
        return this.proxy.getScopVersion();
    }

    @Override
    public void setScopVersion(String version) {
        this.proxy.setScopVersion(version);
    }

    @Override
    public List<ScopDomain> getScopDomainsBySunid(Integer sunid) {
        return this.proxy.getScopDomainsBySunid(sunid);
    }

    @Override
    public void flushCache() {
        logger.info("flushing " + this.getClass().getSimpleName());
        super.flushCache();
        this.scopDescriptionCache.flushCache();
    }

    @Override
    public List<String> getComments(int sunid) {
        return new ArrayList<String>(1);
    }
}

