/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.FileConvert;
import org.biojava.nbio.structure.io.mmcif.model.AtomSite;
import org.biojava.nbio.structure.io.mmcif.model.Cell;
import org.biojava.nbio.structure.io.mmcif.model.Symmetry;
import org.biojava.nbio.structure.xtal.CrystalCell;
import org.biojava.nbio.structure.xtal.SpaceGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MMCIFFileTools {
    private static final Logger logger = LoggerFactory.getLogger(MMCIFFileTools.class);
    private static final String newline = System.getProperty("line.separator");
    public static final String MMCIF_MISSING_VALUE = "?";
    public static final String MMCIF_DEFAULT_VALUE = ".";

    public static String toLoopMmCifHeaderString(String categoryName, String className) throws ClassNotFoundException {
        StringBuilder str = new StringBuilder();
        str.append("loop_" + newline);
        Class<?> c = Class.forName(className);
        for (Field f : c.getDeclaredFields()) {
            str.append(categoryName + MMCIF_DEFAULT_VALUE + f.getName() + newline);
        }
        return str.toString();
    }

    public static String toMMCIF(String categoryName, Object o) {
        StringBuilder sb = new StringBuilder();
        Class<?> c = o.getClass();
        int maxFieldNameLength = MMCIFFileTools.getMaxFieldNameLength(o);
        for (Field f : c.getDeclaredFields()) {
            f.setAccessible(true);
            sb.append(categoryName + MMCIF_DEFAULT_VALUE + f.getName());
            int spacing = maxFieldNameLength - f.getName().length() + 3;
            try {
                String val;
                Object obj = f.get(o);
                if (obj == null) {
                    logger.debug("Field {} is null, will write it out as {}", (Object)f.getName(), (Object)MMCIF_MISSING_VALUE);
                    val = MMCIF_MISSING_VALUE;
                } else {
                    val = (String)obj;
                }
                for (int i = 0; i < spacing; ++i) {
                    sb.append(' ');
                }
                sb.append(MMCIFFileTools.addMmCifQuoting(val));
                sb.append(newline);
            }
            catch (IllegalAccessException e) {
                logger.warn("Field {} is inaccessible", (Object)f.getName());
            }
            catch (ClassCastException e) {
                logger.warn("Could not cast value to String for field {}", (Object)f.getName());
            }
        }
        sb.append("#" + newline);
        return sb.toString();
    }

    public static String toMMCIF(List<Object> list) {
        int[] sizes = MMCIFFileTools.getFieldSizes(list);
        StringBuilder sb = new StringBuilder();
        for (Object o : list) {
            sb.append(MMCIFFileTools.toSingleLoopLineMmCifString(o, sizes));
        }
        sb.append("#" + newline);
        return sb.toString();
    }

    private static String toSingleLoopLineMmCifString(Object a, int[] sizes) {
        StringBuilder str = new StringBuilder();
        Class<?> c = a.getClass();
        if (sizes.length != c.getDeclaredFields().length) {
            throw new IllegalArgumentException("The given sizes of fields differ from the number of declared fields");
        }
        int i = -1;
        for (Field f : c.getDeclaredFields()) {
            ++i;
            f.setAccessible(true);
            try {
                String val;
                Object obj = f.get(a);
                if (obj == null) {
                    logger.debug("Field {} is null, will write it out as {}", (Object)f.getName(), (Object)MMCIF_MISSING_VALUE);
                    val = MMCIF_MISSING_VALUE;
                } else {
                    val = (String)obj;
                }
                str.append(String.format("%-" + sizes[i] + "s ", MMCIFFileTools.addMmCifQuoting(val)));
            }
            catch (IllegalAccessException e) {
                logger.warn("Field {} is inaccessible", (Object)f.getName());
            }
            catch (ClassCastException e) {
                logger.warn("Could not cast value to String for field {}", (Object)f.getName());
            }
        }
        str.append(newline);
        return str.toString();
    }

    private static String addMmCifQuoting(String val) {
        String newval;
        if (val.contains("'")) {
            newval = "\"" + val + "\"";
        } else if (val.contains(" ")) {
            newval = "'" + val + "'";
        } else {
            if (val.contains(" ") && val.contains("'")) {
                logger.warn("Value contains both spaces and single quotes, won't format it: {}. CIF ouptut will likely be invalid.", (Object)val);
            }
            newval = val;
        }
        return newval;
    }

    public static Symmetry convertSpaceGroupToSymmetry(SpaceGroup sg) {
        Symmetry sym = new Symmetry();
        sym.setSpace_group_name_H_M(sg.getShortSymbol());
        return sym;
    }

    public static Cell convertCrystalCellToCell(CrystalCell c) {
        Cell cell = new Cell();
        cell.setLength_a(String.format("%.3f", c.getA()));
        cell.setLength_b(String.format("%.3f", c.getB()));
        cell.setLength_c(String.format("%.3f", c.getC()));
        cell.setAngle_alpha(String.format("%.3f", c.getAlpha()));
        cell.setAngle_beta(String.format("%.3f", c.getBeta()));
        cell.setAngle_gamma(String.format("%.3f", c.getGamma()));
        return cell;
    }

    public static AtomSite convertAtomToAtomSite(Atom a, int model, String chainId, String internalChainId) {
        return MMCIFFileTools.convertAtomToAtomSite(a, model, chainId, internalChainId, a.getPDBserial());
    }

    public static AtomSite convertAtomToAtomSite(Atom a, int model, String chainId, String internalChainId, int atomId) {
        Group g = a.getGroup();
        String record = g.getType().equals((Object)GroupType.HETATM) ? "HETATM" : "ATOM";
        String entityId = "0";
        String labelSeqId = Integer.toString(g.getResidueNumber().getSeqNum());
        if (g.getChain() != null && g.getChain().getCompound() != null) {
            entityId = Integer.toString(g.getChain().getCompound().getMolId());
            labelSeqId = Integer.toString(g.getChain().getCompound().getAlignedResIndex(g, g.getChain()));
        }
        Character altLoc = a.getAltLoc();
        String altLocStr = altLoc.toString();
        if (altLoc == null || altLoc.charValue() == ' ') {
            altLocStr = MMCIF_DEFAULT_VALUE;
        }
        Element e = a.getElement();
        String eString = e.toString().toUpperCase();
        if (e.equals(Element.R)) {
            eString = "X";
        }
        String insCode = MMCIF_MISSING_VALUE;
        if (g.getResidueNumber().getInsCode() != null) {
            insCode = Integer.toString(g.getResidueNumber().getInsCode().charValue());
        }
        AtomSite atomSite = new AtomSite();
        atomSite.setGroup_PDB(record);
        atomSite.setId(Integer.toString(atomId));
        atomSite.setType_symbol(eString);
        atomSite.setLabel_atom_id(a.getName());
        atomSite.setLabel_alt_id(altLocStr);
        atomSite.setLabel_comp_id(g.getPDBName());
        atomSite.setLabel_asym_id(internalChainId);
        atomSite.setLabel_entity_id(entityId);
        atomSite.setLabel_seq_id(labelSeqId);
        atomSite.setPdbx_PDB_ins_code(insCode);
        atomSite.setCartn_x(FileConvert.d3.format(a.getX()));
        atomSite.setCartn_y(FileConvert.d3.format(a.getY()));
        atomSite.setCartn_z(FileConvert.d3.format(a.getZ()));
        atomSite.setOccupancy(FileConvert.d2.format(a.getOccupancy()));
        atomSite.setB_iso_or_equiv(FileConvert.d2.format(a.getTempFactor()));
        atomSite.setAuth_seq_id(Integer.toString(g.getResidueNumber().getSeqNum()));
        atomSite.setAuth_comp_id(g.getPDBName());
        atomSite.setAuth_asym_id(chainId);
        atomSite.setAuth_atom_id(a.getName());
        atomSite.setPdbx_PDB_model_num(Integer.toString(model));
        return atomSite;
    }

    private static List<AtomSite> convertGroupToAtomSites(Group g, int model, String chainId, String internalChainId) {
        ArrayList<AtomSite> list = new ArrayList<AtomSite>();
        int groupsize = g.size();
        for (int atompos = 0; atompos < groupsize; ++atompos) {
            Atom a = null;
            a = g.getAtom(atompos);
            if (a == null) continue;
            list.add(MMCIFFileTools.convertAtomToAtomSite(a, model, chainId, internalChainId));
        }
        if (g.hasAltLoc()) {
            for (Group alt : g.getAltLocs()) {
                list.addAll(MMCIFFileTools.convertGroupToAtomSites(alt, model, chainId, internalChainId));
            }
        }
        return list;
    }

    public static List<AtomSite> convertChainToAtomSites(Chain c, int model, String chainId, String internalChainId) {
        ArrayList<AtomSite> list = new ArrayList<AtomSite>();
        if (c.getCompound() == null) {
            logger.warn("No Compound (entity) found for chain {}: entity_id will be set to 0, label_seq_id will be the same as auth_seq_id", (Object)c.getChainID());
        }
        for (int h = 0; h < c.getAtomLength(); ++h) {
            Group g = c.getAtomGroup(h);
            list.addAll(MMCIFFileTools.convertGroupToAtomSites(g, model, chainId, internalChainId));
        }
        return list;
    }

    public static List<AtomSite> convertStructureToAtomSites(Structure s) {
        ArrayList<AtomSite> list = new ArrayList<AtomSite>();
        for (int m = 0; m < s.nrModels(); ++m) {
            for (Chain c : s.getChains()) {
                list.addAll(MMCIFFileTools.convertChainToAtomSites(c, m + 1, c.getChainID(), c.getInternalChainID()));
            }
        }
        return list;
    }

    private static int[] getFieldSizes(List<Object> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("List of beans is empty!");
        }
        int[] sizes = new int[list.get(0).getClass().getDeclaredFields().length];
        for (Object a : list) {
            Class<?> c = a.getClass();
            int i = -1;
            for (Field f : c.getDeclaredFields()) {
                ++i;
                f.setAccessible(true);
                try {
                    int length;
                    Object obj = f.get(a);
                    if (obj == null) {
                        length = MMCIF_MISSING_VALUE.length();
                    } else {
                        String val = (String)obj;
                        length = MMCIFFileTools.addMmCifQuoting(val).length();
                    }
                    if (length <= sizes[i]) continue;
                    sizes[i] = length;
                }
                catch (IllegalAccessException e) {
                    logger.warn("Field {} is inaccessible", (Object)f.getName());
                }
                catch (ClassCastException e) {
                    logger.warn("Could not cast value to String for field {}", (Object)f.getName());
                }
            }
        }
        return sizes;
    }

    private static int getMaxFieldNameLength(Object a) {
        int size = 0;
        Class<?> c = a.getClass();
        for (Field f : c.getDeclaredFields()) {
            f.setAccessible(true);
            if (f.getName().length() <= size) continue;
            size = f.getName().length();
        }
        return size;
    }
}

