/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.fatcat.calc;

public class FCAlignHelper {
    int M;
    int N;
    double g;
    double h;
    double m;
    double[][] sij;
    char[][] trace;
    char[][] etrace;
    char[][] dtrace;
    int B1;
    int B2;
    int E1;
    int E2;
    double alignScore;
    double identity;
    double similarity;
    int[] sapp;
    int[] sapp0;
    int sappPos;
    int last;
    char[] seq1;
    char[] seq2;
    char[] aln1;
    char[] aln2;
    char[] mark;

    public FCAlignHelper(double[][] sij0, int M0, int N0, double g0, double h0) {
        this.init(M0, N0, g0, h0);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                this.sij[i][j] = sij0[i][j];
            }
        }
        this.doAlign();
    }

    private void init(int M0, int N0, double g0, double h0) {
        this.M = M0;
        this.N = N0;
        this.g = g0;
        this.h = h0;
        this.m = this.g + this.h;
        this.trace = new char[this.M + 1][this.N + 1];
        this.etrace = new char[this.M + 1][this.N + 1];
        this.dtrace = new char[this.M + 1][this.N + 1];
        this.E2 = 0;
        this.E1 = 0;
        this.B2 = 0;
        this.B1 = 0;
        this.alignScore = 0.0;
        this.last = 0;
        this.sapp = new int[this.M + this.N];
        this.sapp0 = this.sapp;
        this.sappPos = 0;
        this.sij = new double[this.M][this.N];
        this.seq1 = new char[this.M + 1];
        this.seq2 = new char[this.N + 1];
        this.mark = null;
        this.aln2 = null;
        this.aln1 = null;
        this.similarity = 0.0;
        this.identity = 0.0;
    }

    private void doAlign() {
        int j;
        double[] CC = new double[this.N + 1];
        double[] DD = new double[this.N + 1];
        double maxs = -100.0;
        CC[0] = 0.0;
        for (j = 1; j <= this.N; ++j) {
            CC[j] = 0.0;
            DD[j] = -this.g;
        }
        for (int i = 1; i <= this.M; ++i) {
            double s = 0.0;
            double c = 0.0;
            CC[0] = 0.0;
            double e = -this.g;
            for (j = 1; j <= this.N; ++j) {
                double d;
                double d2;
                double d3;
                double d4;
                int trace_e = 101;
                c -= this.m;
                e -= this.h;
                if (d4 > d3) {
                    e = c;
                    trace_e = 69;
                }
                int trace_d = 100;
                c = CC[j] - this.m;
                double d5 = DD[j] - this.h;
                if (d2 > d) {
                    d5 = c;
                    trace_d = 68;
                }
                double wa = this.sij[i - 1][j - 1];
                c = s + wa;
                this.trace[i][j] = 115;
                if (e > c) {
                    c = e;
                    this.trace[i][j] = trace_e;
                }
                if (d5 > c) {
                    c = d5;
                    this.trace[i][j] = trace_d;
                }
                this.etrace[i][j] = trace_e;
                this.dtrace[i][j] = trace_d;
                s = CC[j];
                CC[j] = c;
                DD[j] = d5;
                if (c < 0.0) {
                    CC[j] = 0.0;
                    DD[j] = -this.g;
                    c = 0.0;
                    e = -this.g;
                    this.trace[i][j] = 48;
                }
                if (!(c > maxs)) continue;
                this.E1 = i;
                this.E2 = j;
                maxs = c;
            }
        }
        this.alignScore = maxs;
        if (this.trace[this.E1][this.E2] != 's') {
            throw new RuntimeException("FCAlignHelper encoutered Exception: Not ending with substitution");
        }
        this.trace('s', this.E1, this.E2);
        this.checkAlign();
    }

    private void trace(char mod, int i, int j) {
        if (mod == '0' || i <= 0 || j <= 0) {
            this.B1 = i + 1;
            this.B2 = j + 1;
        }
        if (mod == 's') {
            this.trace(this.trace[i - 1][j - 1], i - 1, j - 1);
            this.rep();
        } else if (mod == 'D') {
            this.trace(this.trace[i - 1][j], i - 1, j);
            this.del(1);
        } else if (mod == 'd') {
            this.trace(this.dtrace[i - 1][j], i - 1, j);
            this.del(1);
        } else if (mod == 'E') {
            this.trace(this.trace[i][j - 1], i, j - 1);
            this.ins(1);
        } else if (mod == 'e') {
            this.trace(this.etrace[i][j - 1], i, j - 1);
            this.ins(1);
        }
    }

    private void del(int k) {
        if (this.last < 0) {
            int n = this.sappPos - 1;
            int n2 = this.sapp[n] - k;
            this.sapp[n] = n2;
            this.last = n2;
        } else {
            int n = -k;
            this.sapp[this.sappPos++] = n;
            this.last = n;
        }
    }

    private void ins(int k) {
        if (this.last > 0) {
            int n = this.sappPos - 1;
            int n2 = this.sapp[n] + k;
            this.sapp[n] = n2;
            this.last = n2;
        } else {
            int n = k;
            this.sapp[this.sappPos++] = n;
            this.last = n;
        }
    }

    private void rep() {
        this.sapp[this.sappPos++] = 0;
        this.last = 0;
    }

    private void checkAlign() {
        double sco;
        if (this.sapp[0] != 0) {
            System.err.println(String.format("warn: not a local-alignment result, first operation %d\n", this.sapp[0]));
        }
        if (Math.abs((sco = this.checkScore()) - this.alignScore) > 0.001) {
            System.err.println(String.format("FCAlignHelper: warn: alignment scores are different %f(check) %f(align)\n", sco, this.alignScore));
        }
    }

    private double checkScore() {
        double sco = 0.0;
        int op = 0;
        int s = 0;
        int i = this.B1;
        int j = this.B2;
        while (i <= this.E1 && j <= this.E2) {
            if ((op = this.sapp0[s++]) == 0) {
                sco += this.sij[i - 1][j - 1];
                ++i;
                ++j;
                continue;
            }
            if (op > 0) {
                sco -= this.g + (double)op * this.h;
                j += op;
                continue;
            }
            sco -= this.g - (double)op * this.h;
            i -= op;
        }
        return sco;
    }

    public int getAlignPos(int[][] alignList) {
        int i = this.B1;
        int j = this.B2;
        int s = 0;
        int a = 0;
        while (i <= this.E1 && j <= this.E2) {
            int op;
            if ((op = this.sapp0[s++]) == 0) {
                alignList[0][a] = i - 1;
                alignList[1][a] = j - 1;
                ++a;
                ++i;
                ++j;
                continue;
            }
            if (op > 0) {
                j += op;
                continue;
            }
            i -= op;
        }
        return a;
    }
}

