/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.ce;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JPanel;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.ce.StartupParameters;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.jama.Matrix;

public class GuiWrapper {
    static final String guiPackage = "org.biojava.nbio.structure.gui";
    static final String strucAlignmentDisplay = "org.biojava.nbio.structure.align.gui.StructureAlignmentDisplay";
    static final String displayAFP = "org.biojava.nbio.structure.align.gui.DisplayAFP";
    static final String alignmentGUI = "org.biojava.nbio.structure.align.gui.AlignmentGui";
    static final String strucAligJmol = "org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol";
    static final String scaleMatrixPanel = "org.biojava.nbio.structure.gui.ScaleableMatrixPanel";

    public static boolean isGuiModuleInstalled() {
        String className = displayAFP;
        try {
            Class<?> c = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return true;
    }

    public static Object display(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> c = Class.forName(strucAlignmentDisplay);
        Method display = c.getMethod("display", AFPChain.class, Atom[].class, Atom[].class);
        Object structureAlignmentJmol = display.invoke(null, afpChain, ca1, ca2);
        return structureAlignmentJmol;
    }

    public static void showAlignmentImage(AFPChain afpChain, Atom[] ca1, Atom[] ca2, Object jmol) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> structureAlignmentJmol = Class.forName(strucAligJmol);
        Class<?> c = Class.forName(displayAFP);
        Method show = c.getMethod("showAlignmentImage", AFPChain.class, Atom[].class, Atom[].class, structureAlignmentJmol);
        show.invoke(null, afpChain, ca1, ca2, jmol);
    }

    public static void showStructure(Structure structure) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class<?> structureAlignmentJmol = Class.forName(strucAligJmol);
        Object strucAligJ = structureAlignmentJmol.newInstance();
        Method setS = structureAlignmentJmol.getMethod("setStructure", Structure.class);
        setS.invoke(strucAligJ, structure);
    }

    public static void showAlignmentGUI() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> c = Class.forName(alignmentGUI);
        Method m = c.getMethod("getInstance", null);
        m.invoke(c, (Object[])null);
    }

    public static Structure getAlignedStructure(Atom[] ca1, Atom[] ca2) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> structureAlignmentJmol = Class.forName(strucAligJmol);
        Class<?> c = Class.forName(displayAFP);
        Method show = c.getMethod("getAlignedStructure", Atom[].class, Atom[].class);
        Structure s = (Structure)show.invoke(null, ca1, ca2);
        return s;
    }

    public static JPanel getScaleableMatrixPanel(Matrix m) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class<?> scaleMatrixPanelC = Class.forName(scaleMatrixPanel);
        Method setMatrix = scaleMatrixPanelC.getMethod("setMatrix", Matrix.class);
        JPanel panel = (JPanel)scaleMatrixPanelC.newInstance();
        setMatrix.invoke((Object)panel, m);
        return panel;
    }

    public static Group[] prepareGroupsForDisplay(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> c = Class.forName(strucAlignmentDisplay);
        Method display = c.getMethod("prepareGroupsForDisplay", AFPChain.class, Atom[].class, Atom[].class);
        Object groups = display.invoke(null, afpChain, ca1, ca2);
        return (Group[])groups;
    }

    public static Atom[] getAtomArray(Atom[] ca, List<Group> hetatoms, List<Group> nucs) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> structureAlignmentJmol = Class.forName(strucAligJmol);
        Class<?> c = Class.forName(displayAFP);
        Method show = c.getMethod("getAtomArray", Atom[].class, List.class, List.class);
        Atom[] atoms = (Atom[])show.invoke(null, ca, hetatoms, nucs);
        return atoms;
    }

    public static void showDBResults(StartupParameters params) {
        UserConfiguration config = UserConfiguration.fromStartupParams(params);
        String tableClass = "org.biojava.nbio.structure.align.gui.DBResultTable";
        try {
            Class<?> c = Class.forName(tableClass);
            Object table = c.newInstance();
            Method show = c.getMethod("show", File.class, UserConfiguration.class);
            show.invoke(table, new File(params.getShowDBresult()), config);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Probably structure-gui.jar is not in the classpath, can't show results...");
        }
    }
}

