/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biojava.nbio.structure.align.client.FarmJobParameters;
import org.biojava.nbio.structure.align.client.FarmJobRunnable;
import org.biojava.nbio.structure.align.events.AlignmentProgressListener;
import org.biojava.nbio.structure.align.util.CliTools;
import org.biojava.nbio.structure.align.util.ConfigurationException;
import org.biojava.nbio.structure.scop.CachedRemoteScopInstallation;
import org.biojava.nbio.structure.scop.ScopFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarmJob
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(FarmJob.class);
    private static final String[] mandParams = new String[]{"pdbFilePath"};
    private static final List<String> mandatoryArgs = Arrays.asList(mandParams);
    List<AlignmentProgressListener> progressListeners = null;
    List<FarmJobRunnable> jobs;
    FarmJobParameters params;

    public FarmJob() {
        System.setProperty("biojava.cache.files", "true");
    }

    public FarmJobParameters getParams() {
        return this.params;
    }

    public void setParams(FarmJobParameters params) {
        this.params = params;
    }

    public void addAlignmentProgressListener(AlignmentProgressListener listener) {
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList<AlignmentProgressListener>();
        }
        this.progressListeners.add(listener);
    }

    public void clearListeners() {
        this.progressListeners.clear();
        this.progressListeners = null;
    }

    public static void main(String[] argv) {
        FarmJob job = new FarmJob();
        if (argv.length == 0) {
            job.printHelp();
            return;
        }
        if (argv.length == 1 && (argv[0].equalsIgnoreCase("-h") || argv[0].equalsIgnoreCase("-help") || argv[0].equalsIgnoreCase("--help"))) {
            job.printHelp();
            return;
        }
        FarmJobParameters params = new FarmJobParameters();
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            String value = null;
            if (i < argv.length - 1) {
                value = argv[i + 1];
            }
            if (value != null && value.startsWith("-")) {
                value = null;
            } else {
                ++i;
            }
            String[] tmp = new String[]{arg, value};
            try {
                CliTools.configureBean(params, tmp);
                continue;
            }
            catch (ConfigurationException e) {
                logger.error("Exception", (Throwable)e);
                if (!mandatoryArgs.contains(arg)) continue;
                return;
            }
        }
        if (params.getNrAlignments() == -1 && params.getTime() == -1) {
            logger.error("Please provide either the -time or the -nrAlignments argument!");
            return;
        }
        logger.info("Using parameters: {}", (Object)params);
        job.setParams(params);
        job.run();
    }

    @Override
    public void run() {
        String path = this.params.getPdbFilePath();
        System.setProperty("PDB_DIR", path);
        String cachePath = this.params.getCacheFilePath();
        if (cachePath != null && !cachePath.equals("")) {
            System.setProperty("PDB_CACHE_DIR", cachePath);
        } else {
            System.setProperty("PDB_CACHE_DIR", path);
        }
        CachedRemoteScopInstallation scop = null;
        try {
            scop = new CachedRemoteScopInstallation(true);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + CachedRemoteScopInstallation.class.getName(), e);
        }
        ScopFactory.setScopDatabase(scop);
        String username = this.params.getUsername();
        this.jobs = new ArrayList<FarmJobRunnable>();
        for (int i = 0; i < this.params.getThreads(); ++i) {
            logger.info("starting thread #{}", (Object)(i + 1));
            FarmJobRunnable runner = new FarmJobRunnable(this.params);
            this.params.setUsername(username + "_thread_" + (i + 1));
            this.jobs.add(runner);
            if (this.progressListeners != null) {
                for (AlignmentProgressListener li : this.progressListeners) {
                    runner.addAlignmentProgressListener(li);
                }
            }
            Thread t = new Thread(runner);
            if (this.params.getThreads() > 1 && i < this.params.getThreads() - 1 || this.params.isRunBackground()) {
                logger.info("starting thread #{} in background.", (Object)(i + 1));
                t.start();
                continue;
            }
            logger.info("starting thread #{} in main thread.", (Object)(i + 1));
            t.run();
        }
    }

    public void terminate() {
        logger.info("terminating jobs");
        if (this.jobs == null) {
            return;
        }
        int js = this.jobs.size();
        logger.info("number of jobs: {}", (Object)js);
        for (FarmJobRunnable runner : this.jobs) {
            runner.terminate();
        }
        this.clearListeners();
    }

    public void printHelp() {
        System.out.println("-------------------");
        System.out.println("FarmJob help:");
        System.out.println("-------------------");
        System.out.println("FarmJob accepts the following parameters:");
        System.out.println("");
        System.out.println(" Mandatory:");
        System.out.println("   -pdbFilePath (mandatory) Path to the directory in your file system that contains the PDB files.");
        System.out.println("   provide either -time or -nrAlignments. If both are provided the job stops as soon as any of the criteria has been reached.");
        System.out.println("   -time maximum number of time to run (in seconds). -1 means no time limit, but run -nrAlignment arguments. Default: -1");
        System.out.println("   -nrAlignments number of alignments to calculate. Default: -1");
        System.out.println("");
        System.out.println(" Optional: ");
        System.out.println("   -threads number of parallel threads to calculate alignments. Should be nr. of available CPUs. Default: 1");
        System.out.println("   -server the location of the server URL to talk to. Default : " + FarmJobParameters.DEFAULT_SERVER_URL);
        System.out.println("   -username a unique name that can be given to this client. Can be used to give credit for who is doing the calculations. Default: IP and a random id");
        System.out.println("   -stepSize the number of pairs to be requsted from server. Default: 100");
    }
}

