/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.phylo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.biojava.nbio.core.sequence.MultipleSequenceAlignment;
import org.biojava.nbio.core.sequence.io.FastaWriter;
import org.biojava.nbio.core.sequence.io.template.FastaHeaderFormatInterface;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.io.parsers.FastaParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.msa.Msa;
import org.forester.phylogeny.Phylogeny;

public class ForesterWrapper {
    private ForesterWrapper() {
    }

    public static <C extends Sequence<D>, D extends Compound> Msa convert(MultipleSequenceAlignment<C, D> msa) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        FastaWriter fastaW = new FastaWriter((OutputStream)os, (Collection)msa.getAlignedSequences(), new FastaHeaderFormatInterface<C, D>(){

            public String getHeader(C sequence) {
                return sequence.getAccession().toString();
            }
        });
        fastaW.process();
        String fastaMSA = ((Object)os).toString();
        return FastaParser.parseMsa((String)fastaMSA);
    }

    public static String getNewickString(Phylogeny phylo, boolean writeDistances) throws IOException {
        PhylogenyWriter w = new PhylogenyWriter();
        StringBuffer newickString = w.toNewHampshire(phylo, writeDistances);
        return newickString.toString();
    }

    public static BasicSymmetricalDistanceMatrix cloneDM(BasicSymmetricalDistanceMatrix distM) {
        int n = distM.getSize();
        BasicSymmetricalDistanceMatrix cloneDM = new BasicSymmetricalDistanceMatrix(n);
        for (int i = 0; i < n; ++i) {
            cloneDM.setIdentifier(i, distM.getIdentifier(i));
            for (int j = i + 1; j < n; ++j) {
                cloneDM.setValue(i, j, distM.getValue(i, j));
            }
        }
        return cloneDM;
    }
}

