/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.query;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.biojava.nbio.core.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BlastXMLQuery {
    private static final Logger logger = LoggerFactory.getLogger(BlastXMLQuery.class);
    Document blastDoc = null;

    public BlastXMLQuery(String blastFile) throws Exception {
        logger.info("Start read of {}", (Object)blastFile);
        this.blastDoc = XMLHelper.loadXML((String)blastFile);
        logger.info("Read finished");
    }

    public LinkedHashMap<String, ArrayList<String>> getHitsQueryDef(double maxEScore) throws Exception {
        LinkedHashMap<String, ArrayList<String>> hitsHashMap = new LinkedHashMap<String, ArrayList<String>>();
        logger.info("Query for hits");
        List elementList = XMLHelper.selectElements((Element)this.blastDoc.getDocumentElement(), (String)"BlastOutput_iterations/Iteration[Iteration_hits]");
        logger.info("{} hits", (Object)elementList.size());
        for (Element element : elementList) {
            Element iterationquerydefElement = XMLHelper.selectSingleElement((Element)element, (String)"Iteration_query-def");
            String querydef = iterationquerydefElement.getTextContent();
            Element iterationHitsElement = XMLHelper.selectSingleElement((Element)element, (String)"Iteration_hits");
            List hitList = XMLHelper.selectElements((Element)iterationHitsElement, (String)"Hit");
            for (Element hitElement : hitList) {
                Element hitaccessionElement = XMLHelper.selectSingleElement((Element)hitElement, (String)"Hit_accession");
                String hitaccession = hitaccessionElement.getTextContent();
                Element hithspsElement = XMLHelper.selectSingleElement((Element)hitElement, (String)"Hit_hsps");
                List hspList = XMLHelper.selectElements((Element)hithspsElement, (String)"Hsp");
                for (Element hspElement : hspList) {
                    Element evalueElement = XMLHelper.selectSingleElement((Element)hspElement, (String)"Hsp_evalue");
                    String value = evalueElement.getTextContent();
                    double evalue = Double.parseDouble(value);
                    if (!(evalue <= maxEScore)) continue;
                    ArrayList<String> hits = hitsHashMap.get(querydef);
                    if (hits == null) {
                        hits = new ArrayList();
                        hitsHashMap.put(querydef, hits);
                    }
                    hits.add(hitaccession);
                }
            }
        }
        return hitsHashMap;
    }

    public static void main(String[] args) {
        try {
            BlastXMLQuery blastXMLQuery = new BlastXMLQuery("/Users/Scooter/scripps/dyadic/analysis/454Scaffolds/c1-454Scaffolds-hits-uniprot_fungi.xml");
            LinkedHashMap<String, ArrayList<String>> hits = blastXMLQuery.getHitsQueryDef(1.0E-10);
            logger.info("Hits: {}", hits);
        }
        catch (Exception e) {
            logger.error("Execution: ", (Throwable)e);
        }
    }
}

