/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.twobit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoBitParser
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(TwoBitParser.class);
    public int DEFAULT_BUFFER_SIZE = 10000;
    private RandomAccessFile raf;
    private File f;
    private boolean reverse = false;
    private String[] seq_names;
    private HashMap<String, Long> seq2pos = new HashMap();
    private String cur_seq_name;
    private long[][] cur_nn_blocks;
    private long[][] cur_mask_blocks;
    private long cur_seq_pos;
    private long cur_dna_size;
    private int cur_nn_block_num;
    private int cur_mask_block_num;
    private int[] cur_bits;
    private byte[] buffer;
    private long buffer_size;
    private long buffer_pos;
    private long start_file_pos;
    private long file_pos;
    private static final char[] bit_chars = new char[]{'T', 'C', 'A', 'G'};

    public TwoBitParser(File f) throws Exception {
        this.f = f;
        this.raf = new RandomAccessFile(f, "r");
        long sign = this.readFourBytes();
        if (sign == 440477507L) {
            logger.debug("2bit: Normal number architecture");
        } else if (sign == 1126646042L) {
            this.reverse = true;
            logger.debug("2bit: Reverse number architecture");
        } else {
            throw new Exception("Wrong start signature in 2BIT format");
        }
        this.readFourBytes();
        int seq_qnt = (int)this.readFourBytes();
        this.readFourBytes();
        this.seq_names = new String[seq_qnt];
        for (int i = 0; i < seq_qnt; ++i) {
            int name_len = this.raf.read();
            char[] chars = new char[name_len];
            for (int j = 0; j < name_len; ++j) {
                chars[j] = (char)this.raf.read();
            }
            this.seq_names[i] = String.valueOf(chars);
            long pos = this.readFourBytes();
            this.seq2pos.put(this.seq_names[i], pos);
            logger.debug("2bit: Sequence name=[{}], pos={}", (Object)this.seq_names[i], (Object)pos);
        }
    }

    private long readFourBytes() throws Exception {
        long ret = 0L;
        if (!this.reverse) {
            ret = this.raf.read();
            ret += (long)(this.raf.read() * 256);
            ret += (long)(this.raf.read() * 65536);
            ret += (long)(this.raf.read() * 0x1000000);
        } else {
            ret = this.raf.read() * 0x1000000;
            ret += (long)(this.raf.read() * 65536);
            ret += (long)(this.raf.read() * 256);
            ret += (long)this.raf.read();
        }
        return ret;
    }

    public String[] getSequenceNames() {
        String[] ret = new String[this.seq_names.length];
        System.arraycopy(this.seq_names, 0, ret, 0, this.seq_names.length);
        return ret;
    }

    public void setCurrentSequence(String seq_name) throws Exception {
        int i;
        int i2;
        if (this.cur_seq_name != null) {
            throw new Exception("Sequence [" + this.cur_seq_name + "] was not closed");
        }
        if (this.seq2pos.get(seq_name) == null) {
            throw new Exception("Sequence [" + seq_name + "] was not found in 2bit file");
        }
        this.cur_seq_name = seq_name;
        long pos = this.seq2pos.get(seq_name);
        this.raf.seek(pos);
        long dna_size = this.readFourBytes();
        logger.debug("2bit: Sequence name=[{}], dna_size={}", (Object)this.cur_seq_name, (Object)dna_size);
        this.cur_dna_size = dna_size;
        int nn_block_qnt = (int)this.readFourBytes();
        this.cur_nn_blocks = new long[nn_block_qnt][2];
        for (i2 = 0; i2 < nn_block_qnt; ++i2) {
            this.cur_nn_blocks[i2][0] = this.readFourBytes();
        }
        for (i2 = 0; i2 < nn_block_qnt; ++i2) {
            this.cur_nn_blocks[i2][1] = this.readFourBytes();
        }
        for (i2 = 0; i2 < nn_block_qnt; ++i2) {
            logger.debug("NN-block: [{},{}] ", (Object)this.cur_nn_blocks[i2][0], (Object)this.cur_nn_blocks[i2][1]);
        }
        int mask_block_qnt = (int)this.readFourBytes();
        this.cur_mask_blocks = new long[mask_block_qnt][2];
        for (i = 0; i < mask_block_qnt; ++i) {
            this.cur_mask_blocks[i][0] = this.readFourBytes();
        }
        for (i = 0; i < mask_block_qnt; ++i) {
            this.cur_mask_blocks[i][1] = this.readFourBytes();
        }
        for (i = 0; i < mask_block_qnt; ++i) {
            logger.debug("[{},{}] ", (Object)this.cur_mask_blocks[i][0], (Object)this.cur_mask_blocks[i][1]);
        }
        this.readFourBytes();
        this.start_file_pos = this.raf.getFilePointer();
        this.reset();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.cur_seq_pos = 0L;
        this.cur_nn_block_num = this.cur_nn_blocks.length > 0 ? 0 : -1;
        this.cur_mask_block_num = this.cur_mask_blocks.length > 0 ? 0 : -1;
        this.cur_bits = new int[4];
        this.file_pos = this.start_file_pos;
        this.buffer_size = 0L;
        this.buffer_pos = -1L;
    }

    public long getCurrentSequencePosition() {
        if (this.cur_seq_name == null) {
            throw new RuntimeException("Sequence is not set");
        }
        return this.cur_seq_pos;
    }

    public void setCurrentSequencePosition(long pos) throws IOException {
        if (this.cur_seq_name == null) {
            throw new RuntimeException("Sequence is not set");
        }
        if (pos > this.cur_dna_size) {
            throw new RuntimeException("Postion is too high (more than " + this.cur_dna_size + ")");
        }
        if (this.cur_seq_pos > pos) {
            this.reset();
        }
        this.skip(pos - this.cur_seq_pos);
    }

    private void loadBits() throws IOException {
        if (this.buffer == null || this.buffer_pos < 0L || this.file_pos < this.buffer_pos || this.file_pos >= this.buffer_pos + this.buffer_size) {
            if (this.buffer == null || this.buffer.length != this.DEFAULT_BUFFER_SIZE) {
                this.buffer = new byte[this.DEFAULT_BUFFER_SIZE];
            }
            this.buffer_pos = this.file_pos;
            this.buffer_size = this.raf.read(this.buffer);
        }
        int cur_byte = this.buffer[(int)(this.file_pos - this.buffer_pos)] & 0xFF;
        for (int i = 0; i < 4; ++i) {
            this.cur_bits[3 - i] = cur_byte % 4;
            cur_byte /= 4;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.cur_seq_name == null) {
            throw new IOException("Sequence is not set");
        }
        if (this.cur_seq_pos == this.cur_dna_size) {
            logger.debug("End of sequence (file position:{})", (Object)this.raf.getFilePointer());
            return -1;
        }
        int bit_num = (int)this.cur_seq_pos % 4;
        if (bit_num == 0) {
            this.loadBits();
        } else if (bit_num == 3) {
            ++this.file_pos;
        }
        int ret = 78;
        if (this.cur_nn_block_num >= 0 && this.cur_nn_blocks[this.cur_nn_block_num][0] <= this.cur_seq_pos) {
            if (this.cur_bits[bit_num] != 0) {
                throw new IOException("Wrong data in NN-block (" + this.cur_bits[bit_num] + ") at position " + this.cur_seq_pos);
            }
            if (this.cur_nn_blocks[this.cur_nn_block_num][0] + this.cur_nn_blocks[this.cur_nn_block_num][1] == this.cur_seq_pos + 1L) {
                ++this.cur_nn_block_num;
                if (this.cur_nn_block_num >= this.cur_nn_blocks.length) {
                    this.cur_nn_block_num = -1;
                }
            }
            ret = 78;
        } else {
            ret = bit_chars[this.cur_bits[bit_num]];
        }
        if (this.cur_mask_block_num >= 0 && this.cur_mask_blocks[this.cur_mask_block_num][0] <= this.cur_seq_pos) {
            ret = Character.toLowerCase((char)ret);
            if (this.cur_mask_blocks[this.cur_mask_block_num][0] + this.cur_mask_blocks[this.cur_mask_block_num][1] == this.cur_seq_pos + 1L) {
                ++this.cur_mask_block_num;
                if (this.cur_mask_block_num >= this.cur_mask_blocks.length) {
                    this.cur_mask_block_num = -1;
                }
            }
        }
        ++this.cur_seq_pos;
        return ret;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (this.cur_seq_name == null) {
            throw new IOException("Sequence is not set");
        }
        if (n < 4L) {
            int ret = 0;
            while ((long)ret < n && this.read() >= 0) {
                ++ret;
            }
            return ret;
        }
        if (n > this.cur_dna_size - this.cur_seq_pos) {
            n = this.cur_dna_size - this.cur_seq_pos;
        }
        this.cur_seq_pos += n;
        this.file_pos = this.start_file_pos + this.cur_seq_pos / 4L;
        this.raf.seek(this.file_pos);
        if (this.cur_seq_pos % 4L != 0L) {
            this.loadBits();
        }
        while (this.cur_nn_block_num >= 0 && this.cur_nn_blocks[this.cur_nn_block_num][0] + this.cur_nn_blocks[this.cur_nn_block_num][1] <= this.cur_seq_pos) {
            ++this.cur_nn_block_num;
            if (this.cur_nn_block_num < this.cur_nn_blocks.length) continue;
            this.cur_nn_block_num = -1;
        }
        while (this.cur_mask_block_num >= 0 && this.cur_mask_blocks[this.cur_mask_block_num][0] + this.cur_mask_blocks[this.cur_mask_block_num][1] <= this.cur_seq_pos) {
            ++this.cur_mask_block_num;
            if (this.cur_mask_block_num < this.cur_mask_blocks.length) continue;
            this.cur_mask_block_num = -1;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.cur_seq_name = null;
        this.cur_nn_blocks = null;
        this.cur_mask_blocks = null;
        this.cur_seq_pos = -1L;
        this.cur_dna_size = -1L;
        this.cur_nn_block_num = -1;
        this.cur_mask_block_num = -1;
        this.cur_bits = null;
        this.buffer_size = 0L;
        this.buffer_pos = -1L;
        this.file_pos = -1L;
        this.start_file_pos = -1L;
    }

    @Override
    public int available() throws IOException {
        if (this.cur_seq_name == null) {
            throw new IOException("Sequence is not set");
        }
        return (int)(this.cur_dna_size - this.cur_seq_pos);
    }

    public void closeParser() throws Exception {
        this.raf.close();
    }

    public File getFile() {
        return this.f;
    }

    public String loadFragment(long seq_pos, int len) throws IOException {
        int ch;
        int i;
        if (this.cur_seq_name == null) {
            throw new IOException("Sequence is not set");
        }
        this.setCurrentSequencePosition(seq_pos);
        char[] ret = new char[len];
        for (i = 0; i < len && (ch = this.read()) >= 0; ++i) {
            ret[i] = (char)ch;
        }
        return new String(ret, 0, i);
    }

    public void printFastaSequence() throws IOException {
        if (this.cur_seq_name == null) {
            throw new RuntimeException("Sequence is not set");
        }
        this.printFastaSequence(this.cur_dna_size - this.cur_seq_pos);
    }

    public void printFastaSequence(long len) throws IOException {
        if (this.cur_seq_name == null) {
            throw new RuntimeException("Sequence is not set");
        }
        logger.info(">{} pos={}, len={}", new Object[]{this.cur_seq_name, this.cur_seq_pos, len});
        char[] line = new char[60];
        boolean end = false;
        long qnt_all = 0L;
        while (!end) {
            int qnt;
            for (qnt = 0; qnt < line.length && qnt_all < len; ++qnt, ++qnt_all) {
                int ch = this.read();
                if (ch < 0) {
                    end = true;
                    break;
                }
                line[qnt] = (char)ch;
            }
            if (qnt > 0) {
                logger.info(new String(line, 0, qnt));
            }
            if (qnt_all < len) continue;
            end = true;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            logger.info("Usage: <program> <input.2bit> [<seq_name> [<start> [<length>]]]");
            logger.info("Resulting fasta data will be written in stdout.");
            return;
        }
        try (TwoBitParser p = new TwoBitParser(new File(args[0]));){
            if (args.length == 1) {
                String[] names = p.getSequenceNames();
                for (int i = 0; i < names.length; ++i) {
                    p.setCurrentSequence(names[i]);
                    p.printFastaSequence();
                    p.close();
                }
            } else {
                String name = args[1];
                p.setCurrentSequence(name);
                if (args.length > 2) {
                    long start = Long.parseLong(args[2]);
                    p.skip(start);
                }
                if (args.length > 3) {
                    long len = Long.parseLong(args[3]);
                    p.printFastaSequence(len);
                } else {
                    p.printFastaSequence();
                }
                p.close();
            }
            p.closeParser();
        }
    }
}

