/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.gff;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ListIterator;
import org.biojava.nbio.genome.parsers.gff.Feature;
import org.biojava.nbio.genome.parsers.gff.FeatureI;
import org.biojava.nbio.genome.parsers.gff.FeatureList;
import org.biojava.nbio.genome.parsers.gff.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneIDGFF2Reader {
    private static final Logger logger = LoggerFactory.getLogger(GeneIDGFF2Reader.class);

    public static FeatureList read(String filename) throws IOException {
        logger.info("Reading: {}", (Object)filename);
        FeatureList features = new FeatureList();
        try (BufferedReader br = new BufferedReader(new FileReader(filename));){
            String s = br.readLine();
            while (null != s) {
                Feature f;
                if ((s = s.trim()).length() > 0 && s.charAt(0) != '#' && (f = GeneIDGFF2Reader.parseLine(s)) != null) {
                    features.add(f);
                }
                s = br.readLine();
            }
        }
        return features;
    }

    private static Feature parseLine(String s) {
        int frame;
        Double score;
        int end;
        int start = 0;
        start = end = 0;
        end = s.indexOf(9, start);
        String seqname = s.substring(start, end).trim();
        start = end + 1;
        end = s.indexOf(9, start);
        String source = s.substring(start, end).trim();
        start = end + 1;
        end = s.indexOf(9, start);
        String type = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        String locStart = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        String locEnd = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        try {
            score = Double.parseDouble(s.substring(start, end));
        }
        catch (Exception e) {
            score = 0.0;
        }
        start = end + 1;
        end = s.indexOf(9, start);
        char strand = s.charAt(end - 1);
        Location location = Location.fromBio(Integer.parseInt(locStart), Integer.parseInt(locEnd), strand);
        assert (strand == '-' == location.isNegative());
        start = end + 1;
        end = s.indexOf(9, start);
        try {
            frame = Integer.parseInt(s.substring(start, end));
        }
        catch (Exception e) {
            frame = -1;
        }
        start = end + 1;
        end = s.indexOf(35, start);
        Object attributes = null;
        attributes = end < 0 ? s.substring(start) : s.substring(start, end);
        attributes = "gene_id \"" + (String)attributes + "\";";
        return new Feature(seqname, source, type, location, score, frame, (String)attributes);
    }

    public static void write(FeatureList features, String filename) throws IOException {
        logger.info("Writing: {}", (Object)filename);
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        ListIterator iter = features.listIterator();
        while (iter.hasNext()) {
            Feature feature = (Feature)iter.next();
            GeneIDGFF2Reader.writeLine(feature, bw);
        }
        bw.close();
    }

    private static void writeLine(Feature f, BufferedWriter bw) throws IOException {
        String s = f.seqname() + "\t";
        s = s + f.source() + "\t";
        s = s + f.type() + "\t";
        s = s + f.location().bioStart() + "\t";
        s = s + f.location().bioEnd() + "\t";
        s = s + Double.toString(f.score()) + "\t";
        s = s + f.location().bioStrand() + "\t";
        s = f.frame() == -1 ? s + ".\t" : s + f.frame() + "\t";
        s = s + f.attributes();
        bw.write(s);
        bw.newLine();
    }

    public static void main(String[] args) throws Exception {
        FeatureList listGenes = GeneIDGFF2Reader.read("/Users/Scooter/scripps/dyadic/analysis/454Scaffolds/genemark_hmm.gtf");
        for (FeatureI feature : listGenes) {
            logger.info("Gene Feature: {}", (Object)feature);
        }
    }
}

