/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.gff;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.sequence.CDSSequence;
import org.biojava.nbio.core.sequence.ChromosomeSequence;
import org.biojava.nbio.core.sequence.GeneSequence;
import org.biojava.nbio.core.sequence.SequenceComparator;
import org.biojava.nbio.core.sequence.TranscriptSequence;

public class GFF3Writer {
    public void write(OutputStream outputStream, Map<String, ChromosomeSequence> chromosomeSequenceList) throws Exception {
        outputStream.write("##gff-version 3\n".getBytes());
        for (String key : chromosomeSequenceList.keySet()) {
            ChromosomeSequence chromosomeSequence = chromosomeSequenceList.get(key);
            Object gff3line = "";
            for (GeneSequence geneSequence : chromosomeSequence.getGeneSequences().values()) {
                gff3line = key + "\t" + geneSequence.getSource() + "\tgene\t" + geneSequence.getBioBegin() + "\t" + geneSequence.getBioEnd() + "\t";
                Double score = geneSequence.getSequenceScore();
                gff3line = score == null ? (String)gff3line + ".\t" : (String)gff3line + score + "\t";
                gff3line = (String)gff3line + geneSequence.getStrand().getStringRepresentation() + "\t";
                gff3line = (String)gff3line + ".\t";
                gff3line = (String)gff3line + "ID=" + geneSequence.getAccession().getID() + ";Name=" + geneSequence.getAccession().getID();
                gff3line = (String)gff3line + this.getGFF3Note(geneSequence.getNotesList());
                gff3line = (String)gff3line + "\n";
                outputStream.write(((String)gff3line).getBytes());
                int transcriptIndex = 0;
                for (TranscriptSequence transcriptSequence : geneSequence.getTranscripts().values()) {
                    gff3line = key + "\t" + transcriptSequence.getSource() + "\tmRNA\t" + transcriptSequence.getBioBegin() + "\t" + transcriptSequence.getBioEnd() + "\t";
                    score = transcriptSequence.getSequenceScore();
                    gff3line = score == null ? (String)gff3line + ".\t" : (String)gff3line + score + "\t";
                    gff3line = (String)gff3line + transcriptSequence.getStrand().getStringRepresentation() + "\t";
                    gff3line = (String)gff3line + ".\t";
                    String id = geneSequence.getAccession().getID() + "." + ++transcriptIndex;
                    gff3line = (String)gff3line + "ID=" + id + ";Parent=" + geneSequence.getAccession().getID() + ";Name=" + id;
                    gff3line = (String)gff3line + this.getGFF3Note(transcriptSequence.getNotesList());
                    gff3line = (String)gff3line + "\n";
                    outputStream.write(((String)gff3line).getBytes());
                    String transcriptParentName = geneSequence.getAccession().getID() + "." + transcriptIndex;
                    ArrayList cdsSequenceList = new ArrayList(transcriptSequence.getCDSSequences().values());
                    Collections.sort(cdsSequenceList, new SequenceComparator());
                    for (CDSSequence cdsSequence : cdsSequenceList) {
                        gff3line = key + "\t" + cdsSequence.getSource() + "\tCDS\t" + cdsSequence.getBioBegin() + "\t" + cdsSequence.getBioEnd() + "\t";
                        score = cdsSequence.getSequenceScore();
                        gff3line = score == null ? (String)gff3line + ".\t" : (String)gff3line + score + "\t";
                        gff3line = (String)gff3line + cdsSequence.getStrand().getStringRepresentation() + "\t";
                        gff3line = (String)gff3line + cdsSequence.getPhase() + "\t";
                        gff3line = (String)gff3line + "ID=" + cdsSequence.getAccession().getID() + ";Parent=" + transcriptParentName;
                        gff3line = (String)gff3line + this.getGFF3Note(cdsSequence.getNotesList());
                        gff3line = (String)gff3line + "\n";
                        outputStream.write(((String)gff3line).getBytes());
                    }
                }
            }
        }
    }

    private String getGFF3Note(List<String> notesList) {
        Object notes = "";
        if (notesList.size() > 0) {
            notes = ";Note=";
            int noteindex = 1;
            for (String note : notesList) {
                notes = (String)notes + note;
                if (noteindex >= notesList.size() - 1) continue;
                notes = (String)notes + " ";
            }
        }
        return notes;
    }
}

