/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.cytoband;

import java.io.Serializable;
import org.biojava.nbio.genome.parsers.cytoband.StainType;

public class Cytoband
implements Serializable,
Comparable<Cytoband> {
    private static final long serialVersionUID = 2805976387404499650L;
    String chromosome;
    Integer start;
    Integer end;
    String locus;
    StainType type;

    public String getChromosome() {
        return this.chromosome;
    }

    public void setChromosome(String chromosome) {
        this.chromosome = chromosome;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public StainType getType() {
        return this.type;
    }

    public void setType(StainType type) {
        this.type = type;
    }

    @Override
    public int compareTo(Cytoband o) {
        if (this.chromosome.equals(o.chromosome)) {
            return this.start.compareTo(o.start);
        }
        Short s1 = null;
        try {
            s1 = Short.parseShort(this.chromosome.substring(3));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Short s2 = null;
        try {
            s2 = Short.parseShort(o.chromosome.substring(3));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (s1 == null || s2 == null) {
            return this.chromosome.compareTo(o.chromosome);
        }
        return s1.compareTo(s2);
    }

    public String getLocus() {
        return this.locus;
    }

    public void setLocus(String locus) {
        this.locus = locus;
    }

    public String toString() {
        return "Cytoband [chromosome=" + this.chromosome + ", start=" + this.start + ", end=" + this.end + ", locus=" + this.locus + ", type=" + String.valueOf(this.type) + "]";
    }
}

