/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.io.fastq;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.biojava.nbio.genome.io.fastq.Fastq;
import org.biojava.nbio.genome.io.fastq.FastqParser;
import org.biojava.nbio.genome.io.fastq.FastqReader;
import org.biojava.nbio.genome.io.fastq.FastqVariant;
import org.biojava.nbio.genome.io.fastq.ParseListener;
import org.biojava.nbio.genome.io.fastq.StreamListener;
import org.biojava.nbio.genome.io.fastq.StreamingFastqParser;

abstract class AbstractFastqReader
implements FastqReader {
    AbstractFastqReader() {
    }

    protected abstract FastqVariant getVariant();

    @Override
    public final void parse(Readable readable, ParseListener listener) throws IOException {
        FastqParser.parse(readable, listener);
    }

    @Override
    public final void stream(Readable readable, StreamListener listener) throws IOException {
        StreamingFastqParser.stream(readable, this.getVariant(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterable<Fastq> read(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        BufferedReader reader = null;
        Collect collect = new Collect();
        try {
            reader = new BufferedReader(new FileReader(file));
            this.stream(reader, collect);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return collect.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterable<Fastq> read(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        BufferedReader reader = null;
        Collect collect = new Collect();
        try {
            reader = Resources.asCharSource((URL)url, (Charset)Charset.forName("UTF-8")).openBufferedStream();
            this.stream(reader, collect);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return collect.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterable<Fastq> read(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        BufferedReader reader = null;
        Collect collect = new Collect();
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream));
            this.stream(reader, collect);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return collect.getResult();
    }

    private static final class Collect
    implements StreamListener {
        private final List<Fastq> result = Lists.newArrayList();

        private Collect() {
        }

        @Override
        public void fastq(Fastq fastq) {
            this.result.add(fastq);
        }

        public Iterable<Fastq> getResult() {
            return Iterables.unmodifiableIterable(this.result);
        }
    }
}

