/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.CDSSequence;
import org.biojava.nbio.core.sequence.ChromosomeSequence;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ExonSequence;
import org.biojava.nbio.core.sequence.GeneSequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.TranscriptSequence;
import org.biojava.nbio.core.sequence.io.FastaReaderHelper;
import org.biojava.nbio.genome.parsers.gff.Feature;
import org.biojava.nbio.genome.parsers.gff.FeatureHelper;
import org.biojava.nbio.genome.parsers.gff.FeatureI;
import org.biojava.nbio.genome.parsers.gff.FeatureList;
import org.biojava.nbio.genome.parsers.gff.GFF3Reader;
import org.biojava.nbio.genome.parsers.gff.GeneIDGFF2Reader;
import org.biojava.nbio.genome.parsers.gff.GeneMarkGTFReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneFeatureHelper {
    private static final Logger logger = LoggerFactory.getLogger(GeneFeatureHelper.class);

    public static LinkedHashMap<String, ChromosomeSequence> loadFastaAddGeneFeaturesFromUpperCaseExonFastaFile(File fastaSequenceFile, File uppercaseFastaFile, boolean throwExceptionGeneNotFound) throws Exception {
        LinkedHashMap<String, ChromosomeSequence> chromosomeSequenceList = new LinkedHashMap<String, ChromosomeSequence>();
        Map dnaSequenceList = FastaReaderHelper.readFastaDNASequence((File)fastaSequenceFile);
        for (String accession : dnaSequenceList.keySet()) {
            DNASequence contigSequence = (DNASequence)dnaSequenceList.get(accession);
            ChromosomeSequence chromsomeSequence = new ChromosomeSequence(contigSequence.getSequenceAsString());
            chromsomeSequence.setAccession(contigSequence.getAccession());
            chromosomeSequenceList.put(accession, chromsomeSequence);
        }
        Map geneSequenceList = FastaReaderHelper.readFastaDNASequence((File)uppercaseFastaFile);
        for (DNASequence dnaSequence : geneSequenceList.values()) {
            String geneSequence = dnaSequence.getSequenceAsString();
            String lcGeneSequence = geneSequence.toLowerCase();
            String reverseGeneSequence = dnaSequence.getReverse().getSequenceAsString();
            String lcReverseGeneSequence = reverseGeneSequence.toLowerCase();
            Integer bioStart = null;
            Integer bioEnd = null;
            Strand strand = Strand.POSITIVE;
            boolean geneFound = false;
            String accession = "";
            DNASequence contigDNASequence = null;
            Iterator iterator = dnaSequenceList.keySet().iterator();
            while (iterator.hasNext()) {
                String id;
                accession = id = (String)iterator.next();
                contigDNASequence = (DNASequence)dnaSequenceList.get(id);
                String contigSequence = contigDNASequence.getSequenceAsString().toLowerCase();
                bioStart = contigSequence.indexOf(lcGeneSequence);
                if (bioStart != -1) {
                    bioStart = bioStart + 1;
                    bioEnd = bioStart + geneSequence.length() - 1;
                    geneFound = true;
                    break;
                }
                bioStart = contigSequence.indexOf(lcReverseGeneSequence);
                if (bioStart == -1) continue;
                bioStart = bioStart + 1;
                bioEnd = bioStart - geneSequence.length() - 1;
                strand = Strand.NEGATIVE;
                geneFound = true;
                break;
            }
            if (geneFound) {
                String geneaccession;
                logger.info("Gene {} found at {} {} {} {}", new Object[]{dnaSequence.getAccession().toString(), contigDNASequence.getAccession().toString(), bioStart, bioEnd, strand});
                ChromosomeSequence chromosomeSequence = chromosomeSequenceList.get(accession);
                ArrayList<Integer> exonBoundries = new ArrayList<Integer>();
                for (int i = 0; i < geneSequence.length(); ++i) {
                    if (i == 0 && Character.isUpperCase(geneSequence.charAt(i))) {
                        exonBoundries.add(i);
                        continue;
                    }
                    if (i == geneSequence.length() - 1) {
                        exonBoundries.add(i);
                        continue;
                    }
                    if (Character.isUpperCase(geneSequence.charAt(i)) && Character.isLowerCase(geneSequence.charAt(i - 1))) {
                        exonBoundries.add(i);
                        continue;
                    }
                    if (!Character.isUpperCase(geneSequence.charAt(i)) || !Character.isLowerCase(geneSequence.charAt(i + 1))) continue;
                    exonBoundries.add(i);
                }
                if (strand == Strand.NEGATIVE) {
                    Collections.reverse(exonBoundries);
                }
                String note = geneaccession = dnaSequence.getAccession().getID();
                String[] values = geneaccession.split(" ");
                geneaccession = values[0];
                GeneSequence geneSeq = chromosomeSequence.addGene(new AccessionID(geneaccession), bioStart.intValue(), bioEnd.intValue(), strand);
                geneSeq.addNote(note);
                geneSeq.setSource(uppercaseFastaFile.getName());
                int runningFrameLength = 0;
                for (int i = 0; i < exonBoundries.size() - 1; i += 2) {
                    int cdsBioStart = (Integer)exonBoundries.get(i) + bioStart;
                    int cdsBioEnd = (Integer)exonBoundries.get(i + 1) + bioStart;
                    int remainder = (runningFrameLength = runningFrameLength + Math.abs(cdsBioEnd - cdsBioStart) + 1) % 3;
                    if (remainder != 1 && remainder != 2) continue;
                }
                continue;
            }
            if (throwExceptionGeneNotFound) {
                throw new Exception(dnaSequence.getAccession().toString() + " not found");
            }
            logger.info("Gene not found {}", (Object)dnaSequence.getAccession().toString());
        }
        return chromosomeSequenceList;
    }

    public static void outputFastaSequenceLengthGFF3(File fastaSequenceFile, File gffFile) throws Exception {
        Map dnaSequenceList = FastaReaderHelper.readFastaDNASequence((File)fastaSequenceFile);
        String fileName = fastaSequenceFile.getName();
        FileWriter fw = new FileWriter(gffFile);
        String newLine = System.getProperty("line.separator");
        fw.write("##gff-version 3" + newLine);
        for (DNASequence dnaSequence : dnaSequenceList.values()) {
            String gff3line = dnaSequence.getAccession().getID() + "\t" + fileName + "\tcontig\t1\t" + dnaSequence.getBioEnd() + "\t.\t.\t.\tName=" + dnaSequence.getAccession().getID() + newLine;
            fw.write(gff3line);
        }
        fw.close();
    }

    public static Map<String, ChromosomeSequence> loadFastaAddGeneFeaturesFromGeneIDGFF2(File fastaSequenceFile, File gffFile) throws Exception {
        Map dnaSequenceList = FastaReaderHelper.readFastaDNASequence((File)fastaSequenceFile);
        Map<String, ChromosomeSequence> chromosomeSequenceList = GeneFeatureHelper.getChromosomeSequenceFromDNASequence(dnaSequenceList);
        FeatureList listGenes = GeneIDGFF2Reader.read(gffFile.getAbsolutePath());
        GeneFeatureHelper.addGeneIDGFF2GeneFeatures(chromosomeSequenceList, listGenes);
        return chromosomeSequenceList;
    }

    public static void addGeneIDGFF2GeneFeatures(Map<String, ChromosomeSequence> chromosomeSequenceList, FeatureList listGenes) throws Exception {
        Collection<String> geneIds = listGenes.attributeValues("gene_id");
        for (String geneid : geneIds) {
            FeatureList gene = listGenes.selectByAttribute("gene_id", geneid);
            FeatureI geneFeature = (FeatureI)gene.get(0);
            ChromosomeSequence seq = chromosomeSequenceList.get(geneFeature.seqname());
            geneid = geneid.replaceAll("_", ".G");
            AccessionID geneAccessionID = new AccessionID(geneid);
            GeneSequence geneSequence = null;
            Collection<String> transcriptids = gene.attributeValues("gene_id");
            for (String transcriptid : transcriptids) {
                FeatureList transcriptFeature = listGenes.selectByAttribute("gene_id", transcriptid);
                transcriptid = transcriptid.replaceAll("_", ".G");
                Integer startCodonBegin = null;
                Integer stopCodonEnd = null;
                FeatureList firstFeatures = transcriptFeature.selectByType("First");
                FeatureList terminalFeatures = transcriptFeature.selectByType("Terminal");
                FeatureList internalFeatures = transcriptFeature.selectByType("Internal");
                FeatureList singleFeatures = transcriptFeature.selectByType("Single");
                FeatureList cdsFeatures = new FeatureList();
                cdsFeatures.add(firstFeatures);
                cdsFeatures.add(terminalFeatures);
                cdsFeatures.add(internalFeatures);
                cdsFeatures.add(singleFeatures);
                cdsFeatures = cdsFeatures.sortByStart();
                Strand strand = Strand.POSITIVE;
                FeatureI feature = (FeatureI)cdsFeatures.get(0);
                if (feature.location().isNegative()) {
                    strand = Strand.NEGATIVE;
                }
                if (startCodonBegin == null) {
                    FeatureI firstFeature = (FeatureI)cdsFeatures.get(0);
                    startCodonBegin = strand == Strand.NEGATIVE ? Integer.valueOf(firstFeature.location().bioEnd()) : Integer.valueOf(firstFeature.location().bioStart());
                }
                if (stopCodonEnd == null) {
                    FeatureI lastFeature = (FeatureI)cdsFeatures.get(cdsFeatures.size() - 1);
                    stopCodonEnd = strand == Strand.NEGATIVE ? Integer.valueOf(lastFeature.location().bioStart()) : Integer.valueOf(lastFeature.location().bioEnd());
                }
                if (startCodonBegin > stopCodonEnd) {
                    int temp = startCodonBegin;
                    startCodonBegin = stopCodonEnd;
                    stopCodonEnd = temp;
                }
                AccessionID transcriptAccessionID = new AccessionID(transcriptid);
                if (geneSequence == null) {
                    geneSequence = seq.addGene(geneAccessionID, startCodonBegin.intValue(), stopCodonEnd.intValue(), strand);
                    geneSequence.setSource(((Feature)feature).source());
                } else {
                    if (startCodonBegin < geneSequence.getBioBegin()) {
                        geneSequence.setBioBegin(startCodonBegin);
                    }
                    if (stopCodonEnd > geneSequence.getBioBegin()) {
                        geneSequence.setBioEnd(stopCodonEnd);
                    }
                }
                TranscriptSequence transcriptSequence = geneSequence.addTranscript(transcriptAccessionID, startCodonBegin.intValue(), stopCodonEnd.intValue());
                for (FeatureI cdsFeature : cdsFeatures) {
                    Feature cds = (Feature)cdsFeature;
                    Object cdsName = cds.getAttribute("transcript_name");
                    if (cdsName == null || ((String)cdsName).length() == 0) {
                        cdsName = transcriptid + "-cds-" + cds.location().bioStart() + "-" + cds.location().bioEnd();
                    }
                    AccessionID cdsAccessionID = new AccessionID((String)cdsName);
                    CDSSequence cdsSequence = transcriptSequence.addCDS(cdsAccessionID, cdsFeature.location().bioStart(), cdsFeature.location().bioEnd(), cds.frame());
                    cdsSequence.setSequenceScore(Double.valueOf(cds.score()));
                }
            }
        }
    }

    public static Map<String, ChromosomeSequence> getChromosomeSequenceFromDNASequence(Map<String, DNASequence> dnaSequenceList) {
        LinkedHashMap<String, ChromosomeSequence> chromosomeSequenceList = new LinkedHashMap<String, ChromosomeSequence>();
        for (String key : dnaSequenceList.keySet()) {
            DNASequence dnaSequence = dnaSequenceList.get(key);
            ChromosomeSequence chromosomeSequence = new ChromosomeSequence(dnaSequence.getProxySequenceReader());
            chromosomeSequence.setAccession(dnaSequence.getAccession());
            chromosomeSequenceList.put(key, chromosomeSequence);
        }
        return chromosomeSequenceList;
    }

    public static Map<String, ChromosomeSequence> loadFastaAddGeneFeaturesFromGmodGFF3(File fastaSequenceFile, File gffFile, boolean lazyloadsequences) throws Exception {
        Map dnaSequenceList = FastaReaderHelper.readFastaDNASequence((File)fastaSequenceFile, (boolean)lazyloadsequences);
        Map<String, ChromosomeSequence> chromosomeSequenceList = GeneFeatureHelper.getChromosomeSequenceFromDNASequence(dnaSequenceList);
        FeatureList listGenes = GFF3Reader.read(gffFile.getAbsolutePath());
        GeneFeatureHelper.addGmodGFF3GeneFeatures(chromosomeSequenceList, listGenes);
        return chromosomeSequenceList;
    }

    public static void addGmodGFF3GeneFeatures(Map<String, ChromosomeSequence> chromosomeSequenceList, FeatureList listGenes) throws Exception {
        FeatureList mRNAFeatures = listGenes.selectByType("mRNA");
        LinkedHashMap<String, FeatureList> featureIDHashMap = FeatureHelper.buildFeatureAtrributeIndex("ID", listGenes);
        LinkedHashMap<String, FeatureList> featureParentHashMap = FeatureHelper.buildFeatureAtrributeIndex("Parent", listGenes);
        for (FeatureI f : mRNAFeatures) {
            FeatureList stopCodonList;
            String geneID;
            String geneNote = null;
            String geneSource = null;
            String sequenceName = null;
            ChromosomeSequence seq = null;
            GeneSequence geneSequence = null;
            Feature mRNAFeature = (Feature)f;
            String mRNAID = mRNAFeature.getAttribute("ID");
            String mRNAsource = mRNAFeature.source();
            String mRNANote = mRNAFeature.getAttribute("Note");
            String mRNAParent = mRNAFeature.getAttribute("Parent");
            if (mRNAParent != null && mRNAParent.length() > 0) {
                FeatureList geneFeatureList = featureIDHashMap.get(mRNAParent);
                Feature geneFeature = (Feature)geneFeatureList.get(0);
                geneID = geneFeature.getAttribute("ID");
                geneNote = geneFeature.getAttribute("Note");
                geneSource = geneFeature.source();
                sequenceName = geneFeature.seqname();
            } else {
                geneID = mRNAID;
                geneSource = mRNAsource;
                sequenceName = mRNAFeature.seqname();
            }
            seq = chromosomeSequenceList.get(sequenceName);
            AccessionID geneAccessionID = new AccessionID(geneID);
            FeatureList mRNAChildren = featureParentHashMap.get(mRNAID);
            FeatureList cdsFeatures = mRNAChildren.selectByType("CDS");
            FeatureI feature = (FeatureI)cdsFeatures.get(0);
            Strand strand = Strand.POSITIVE;
            if (feature.location().isNegative()) {
                strand = Strand.NEGATIVE;
            }
            cdsFeatures = cdsFeatures.sortByStart();
            FeatureI startCodon = null;
            FeatureI stopCodon = null;
            Integer startCodonBegin = null;
            Integer stopCodonEnd = null;
            Object startCodonName = "";
            Object stopCodonName = "";
            FeatureList startCodonList = mRNAChildren.selectByType("five_prime_UTR");
            if (startCodonList != null && startCodonList.size() > 0) {
                startCodon = (FeatureI)startCodonList.get(0);
                startCodonBegin = strand == Strand.NEGATIVE ? Integer.valueOf(startCodon.location().bioEnd()) : Integer.valueOf(startCodon.location().bioStart());
                startCodonName = startCodon.getAttribute("ID");
            }
            if ((stopCodonList = mRNAChildren.selectByType("three_prime_UTR")) != null && stopCodonList.size() > 0) {
                stopCodon = (FeatureI)stopCodonList.get(0);
                stopCodonEnd = strand == Strand.NEGATIVE ? Integer.valueOf(stopCodon.location().bioStart()) : Integer.valueOf(stopCodon.location().bioEnd());
                stopCodonName = stopCodon.getAttribute("ID");
            }
            if (startCodonBegin == null) {
                FeatureI firstFeature;
                if (strand == Strand.NEGATIVE) {
                    firstFeature = (FeatureI)cdsFeatures.get(0);
                    startCodonBegin = firstFeature.location().bioEnd();
                } else {
                    firstFeature = (FeatureI)cdsFeatures.get(0);
                    startCodonBegin = firstFeature.location().bioStart();
                }
            }
            if (stopCodonEnd == null) {
                FeatureI lastFeature;
                if (strand == Strand.NEGATIVE) {
                    lastFeature = (FeatureI)cdsFeatures.get(cdsFeatures.size() - 1);
                    stopCodonEnd = lastFeature.location().bioStart();
                } else {
                    lastFeature = (FeatureI)cdsFeatures.get(cdsFeatures.size() - 1);
                    stopCodonEnd = lastFeature.location().bioEnd();
                }
            }
            if (startCodonBegin > stopCodonEnd) {
                int temp = startCodonBegin;
                startCodonBegin = stopCodonEnd;
                stopCodonEnd = temp;
            }
            AccessionID transcriptAccessionID = new AccessionID(mRNAID);
            geneSequence = seq.getGene(geneID);
            if (geneSequence == null) {
                geneSequence = seq.addGene(geneAccessionID, startCodonBegin.intValue(), stopCodonEnd.intValue(), strand);
                geneSequence.setSource(geneSource);
                if (geneNote != null && geneNote.length() > 0) {
                    geneSequence.addNote(geneNote);
                }
            } else {
                if (startCodonBegin < geneSequence.getBioBegin()) {
                    geneSequence.setBioBegin(startCodonBegin);
                }
                if (stopCodonEnd > geneSequence.getBioBegin()) {
                    geneSequence.setBioEnd(stopCodonEnd);
                }
            }
            TranscriptSequence transcriptSequence = geneSequence.addTranscript(transcriptAccessionID, startCodonBegin.intValue(), stopCodonEnd.intValue());
            transcriptSequence.setSource(mRNAsource);
            if (mRNANote != null && mRNANote.length() > 0) {
                transcriptSequence.addNote(mRNANote);
            }
            if (startCodon != null) {
                if (startCodonName == null || ((String)startCodonName).length() == 0) {
                    startCodonName = mRNAID + "-start_codon-" + startCodon.location().bioStart() + "-" + startCodon.location().bioEnd();
                }
                transcriptSequence.addStartCodonSequence(new AccessionID((String)startCodonName), startCodon.location().bioStart(), startCodon.location().bioEnd());
            }
            if (stopCodon != null) {
                if (stopCodonName == null || ((String)stopCodonName).length() == 0) {
                    stopCodonName = mRNAID + "-stop_codon-" + stopCodon.location().bioStart() + "-" + stopCodon.location().bioEnd();
                }
                transcriptSequence.addStopCodonSequence(new AccessionID((String)stopCodonName), stopCodon.location().bioStart(), stopCodon.location().bioEnd());
            }
            for (FeatureI cdsFeature : cdsFeatures) {
                Feature cds = (Feature)cdsFeature;
                String cdsNote = cdsFeature.getAttribute("Note");
                String cdsSource = cds.source();
                Object cdsName = cds.getAttribute("ID");
                if (cdsName == null || ((String)cdsName).length() == 0) {
                    cdsName = mRNAID + "-cds-" + cds.location().bioStart() + "-" + cds.location().bioEnd();
                }
                AccessionID cdsAccessionID = new AccessionID((String)cdsName);
                ExonSequence exonSequence = geneSequence.addExon(cdsAccessionID, cdsFeature.location().bioStart(), cdsFeature.location().bioEnd());
                exonSequence.setSource(cdsSource);
                if (cdsNote != null && cdsNote.length() > 0) {
                    exonSequence.addNote(cdsNote);
                }
                transcriptSequence.addCDS(cdsAccessionID, cdsFeature.location().bioStart(), cdsFeature.location().bioEnd(), cds.frame());
            }
            geneSequence.addIntronsUsingExons();
        }
    }

    public static Map<String, ChromosomeSequence> loadFastaAddGeneFeaturesFromGlimmerGFF3(File fastaSequenceFile, File gffFile) throws Exception {
        Map dnaSequenceList = FastaReaderHelper.readFastaDNASequence((File)fastaSequenceFile);
        Map<String, ChromosomeSequence> chromosomeSequenceList = GeneFeatureHelper.getChromosomeSequenceFromDNASequence(dnaSequenceList);
        FeatureList listGenes = GFF3Reader.read(gffFile.getAbsolutePath());
        GeneFeatureHelper.addGlimmerGFF3GeneFeatures(chromosomeSequenceList, listGenes);
        return chromosomeSequenceList;
    }

    public static void addGlimmerGFF3GeneFeatures(Map<String, ChromosomeSequence> chromosomeSequenceList, FeatureList listGenes) throws Exception {
        FeatureList mRNAFeatures = listGenes.selectByType("mRNA");
        for (FeatureI f : mRNAFeatures) {
            FeatureList stopCodonList;
            Feature mRNAFeature = (Feature)f;
            String geneid = mRNAFeature.getAttribute("ID");
            String source = mRNAFeature.source();
            FeatureList gene = listGenes.selectByAttribute("Parent", geneid);
            FeatureI geneFeature = (FeatureI)gene.get(0);
            ChromosomeSequence seq = chromosomeSequenceList.get(geneFeature.seqname());
            AccessionID geneAccessionID = new AccessionID(geneid);
            GeneSequence geneSequence = null;
            FeatureList cdsFeatures = gene.selectByType("CDS");
            FeatureI feature = (FeatureI)cdsFeatures.get(0);
            Strand strand = Strand.POSITIVE;
            if (feature.location().isNegative()) {
                strand = Strand.NEGATIVE;
            }
            cdsFeatures = cdsFeatures.sortByStart();
            FeatureI startCodon = null;
            FeatureI stopCodon = null;
            Integer startCodonBegin = null;
            Integer stopCodonEnd = null;
            Object startCodonName = "";
            Object stopCodonName = "";
            FeatureList startCodonList = gene.selectByAttribute("Note", "initial-exon");
            if (startCodonList != null && startCodonList.size() > 0) {
                startCodon = (FeatureI)startCodonList.get(0);
                startCodonBegin = strand == Strand.NEGATIVE ? Integer.valueOf(startCodon.location().bioEnd()) : Integer.valueOf(startCodon.location().bioStart());
                startCodonName = startCodon.getAttribute("ID");
            }
            if ((stopCodonList = gene.selectByAttribute("Note", "final-exon")) != null && stopCodonList.size() > 0) {
                stopCodon = (FeatureI)stopCodonList.get(0);
                stopCodonEnd = strand == Strand.NEGATIVE ? Integer.valueOf(stopCodon.location().bioStart()) : Integer.valueOf(stopCodon.location().bioEnd());
                stopCodonName = stopCodon.getAttribute("ID");
            }
            if (startCodonBegin == null) {
                FeatureI firstFeature;
                if (strand == Strand.NEGATIVE) {
                    firstFeature = (FeatureI)cdsFeatures.get(0);
                    startCodonBegin = firstFeature.location().bioEnd();
                } else {
                    firstFeature = (FeatureI)cdsFeatures.get(0);
                    startCodonBegin = firstFeature.location().bioStart();
                }
            }
            if (stopCodonEnd == null) {
                FeatureI lastFeature;
                if (strand == Strand.NEGATIVE) {
                    lastFeature = (FeatureI)cdsFeatures.get(cdsFeatures.size() - 1);
                    stopCodonEnd = lastFeature.location().bioStart();
                } else {
                    lastFeature = (FeatureI)cdsFeatures.get(cdsFeatures.size() - 1);
                    stopCodonEnd = lastFeature.location().bioEnd();
                }
            }
            if (startCodonBegin > stopCodonEnd) {
                int temp = startCodonBegin;
                startCodonBegin = stopCodonEnd;
                stopCodonEnd = temp;
            }
            AccessionID transcriptAccessionID = new AccessionID(geneid);
            if (geneSequence == null) {
                geneSequence = seq.addGene(geneAccessionID, startCodonBegin.intValue(), stopCodonEnd.intValue(), strand);
                geneSequence.setSource(source);
            }
            TranscriptSequence transcriptSequence = geneSequence.addTranscript(transcriptAccessionID, startCodonBegin.intValue(), stopCodonEnd.intValue());
            if (startCodon != null) {
                if (startCodonName == null || ((String)startCodonName).length() == 0) {
                    startCodonName = geneid + "-start_codon-" + startCodon.location().bioStart() + "-" + startCodon.location().bioEnd();
                }
                transcriptSequence.addStartCodonSequence(new AccessionID((String)startCodonName), startCodon.location().bioStart(), startCodon.location().bioEnd());
            }
            if (stopCodon != null) {
                if (stopCodonName == null || ((String)stopCodonName).length() == 0) {
                    stopCodonName = geneid + "-stop_codon-" + stopCodon.location().bioStart() + "-" + stopCodon.location().bioEnd();
                }
                transcriptSequence.addStopCodonSequence(new AccessionID((String)stopCodonName), stopCodon.location().bioStart(), stopCodon.location().bioEnd());
            }
            for (FeatureI cdsFeature : cdsFeatures) {
                Feature cds = (Feature)cdsFeature;
                Object cdsName = cds.getAttribute("ID");
                if (cdsName == null || ((String)cdsName).length() == 0) {
                    cdsName = geneid + "-cds-" + cds.location().bioStart() + "-" + cds.location().bioEnd();
                }
                AccessionID cdsAccessionID = new AccessionID((String)cdsName);
                transcriptSequence.addCDS(cdsAccessionID, cdsFeature.location().bioStart(), cdsFeature.location().bioEnd(), cds.frame());
            }
        }
    }

    public static Map<String, ChromosomeSequence> loadFastaAddGeneFeaturesFromGeneMarkGTF(File fastaSequenceFile, File gffFile) throws Exception {
        Map dnaSequenceList = FastaReaderHelper.readFastaDNASequence((File)fastaSequenceFile);
        Map<String, ChromosomeSequence> chromosomeSequenceList = GeneFeatureHelper.getChromosomeSequenceFromDNASequence(dnaSequenceList);
        FeatureList listGenes = GeneMarkGTFReader.read(gffFile.getAbsolutePath());
        GeneFeatureHelper.addGeneMarkGTFGeneFeatures(chromosomeSequenceList, listGenes);
        return chromosomeSequenceList;
    }

    public static void addGeneMarkGTFGeneFeatures(Map<String, ChromosomeSequence> chromosomeSequenceList, FeatureList listGenes) throws Exception {
        Collection<String> geneIds = listGenes.attributeValues("gene_id");
        for (String geneid : geneIds) {
            FeatureList gene = listGenes.selectByAttribute("gene_id", geneid);
            FeatureI geneFeature = (FeatureI)gene.get(0);
            ChromosomeSequence seq = chromosomeSequenceList.get(geneFeature.seqname());
            AccessionID geneAccessionID = new AccessionID(geneid);
            GeneSequence geneSequence = null;
            Collection<String> transcriptids = gene.attributeValues("transcript_id");
            for (String transcriptid : transcriptids) {
                FeatureList stopCodonList;
                FeatureList transcriptFeature = listGenes.selectByAttribute("transcript_id", transcriptid);
                FeatureList cdsFeatures = transcriptFeature.selectByType("CDS");
                cdsFeatures = cdsFeatures.sortByStart();
                FeatureI feature = (FeatureI)cdsFeatures.get(0);
                Strand strand = Strand.POSITIVE;
                if (feature.location().isNegative()) {
                    strand = Strand.NEGATIVE;
                }
                FeatureI startCodon = null;
                FeatureI stopCodon = null;
                Integer startCodonBegin = null;
                Integer stopCodonEnd = null;
                Object startCodonName = "";
                Object stopCodonName = "";
                FeatureList startCodonList = transcriptFeature.selectByType("start_codon");
                if (startCodonList != null && startCodonList.size() > 0) {
                    startCodon = (FeatureI)startCodonList.get(0);
                    startCodonBegin = strand == Strand.POSITIVE ? Integer.valueOf(startCodon.location().bioStart()) : Integer.valueOf(startCodon.location().bioEnd());
                    startCodonName = startCodon.getAttribute("transcript_name");
                }
                if ((stopCodonList = transcriptFeature.selectByType("stop_codon")) != null && stopCodonList.size() > 0) {
                    stopCodon = (FeatureI)stopCodonList.get(0);
                    stopCodonEnd = strand == Strand.POSITIVE ? Integer.valueOf(stopCodon.location().bioEnd()) : Integer.valueOf(stopCodon.location().bioStart());
                    stopCodonName = stopCodon.getAttribute("transcript_name");
                }
                if (startCodonBegin == null) {
                    FeatureI firstFeature;
                    if (strand == Strand.NEGATIVE) {
                        firstFeature = (FeatureI)cdsFeatures.get(0);
                        startCodonBegin = firstFeature.location().bioEnd();
                    } else {
                        firstFeature = (FeatureI)cdsFeatures.get(0);
                        startCodonBegin = firstFeature.location().bioStart();
                    }
                }
                if (stopCodonEnd == null) {
                    FeatureI lastFeature;
                    if (strand == Strand.NEGATIVE) {
                        lastFeature = (FeatureI)cdsFeatures.get(cdsFeatures.size() - 1);
                        stopCodonEnd = lastFeature.location().bioStart();
                    } else {
                        lastFeature = (FeatureI)cdsFeatures.get(cdsFeatures.size() - 1);
                        stopCodonEnd = lastFeature.location().bioEnd();
                    }
                }
                if (startCodonBegin > stopCodonEnd) {
                    int temp = startCodonBegin;
                    startCodonBegin = stopCodonEnd;
                    stopCodonEnd = temp;
                }
                AccessionID transcriptAccessionID = new AccessionID(transcriptid);
                if (geneSequence == null) {
                    geneSequence = seq.addGene(geneAccessionID, startCodonBegin.intValue(), stopCodonEnd.intValue(), strand);
                    geneSequence.setSource(((Feature)feature).source());
                } else {
                    if (startCodonBegin < geneSequence.getBioBegin()) {
                        geneSequence.setBioBegin(startCodonBegin);
                    }
                    if (stopCodonEnd > geneSequence.getBioBegin()) {
                        geneSequence.setBioEnd(stopCodonEnd);
                    }
                }
                TranscriptSequence transcriptSequence = geneSequence.addTranscript(transcriptAccessionID, startCodonBegin.intValue(), stopCodonEnd.intValue());
                if (startCodon != null) {
                    if (startCodonName == null || ((String)startCodonName).length() == 0) {
                        startCodonName = transcriptid + "-start_codon-" + startCodon.location().bioStart() + "-" + startCodon.location().bioEnd();
                    }
                    transcriptSequence.addStartCodonSequence(new AccessionID((String)startCodonName), startCodon.location().bioStart(), startCodon.location().bioEnd());
                }
                if (stopCodon != null) {
                    if (stopCodonName == null || ((String)stopCodonName).length() == 0) {
                        stopCodonName = transcriptid + "-stop_codon-" + stopCodon.location().bioStart() + "-" + stopCodon.location().bioEnd();
                    }
                    transcriptSequence.addStopCodonSequence(new AccessionID((String)stopCodonName), stopCodon.location().bioStart(), stopCodon.location().bioEnd());
                }
                for (FeatureI cdsFeature : cdsFeatures) {
                    Feature cds = (Feature)cdsFeature;
                    int frame = cds.frame();
                    frame = frame == 1 ? 2 : (frame == 2 ? 1 : 0);
                    Object cdsName = cds.getAttribute("transcript_name");
                    if (cdsName == null || ((String)cdsName).length() == 0) {
                        cdsName = transcriptid + "-cds-" + cds.location().bioStart() + "-" + cds.location().bioEnd();
                    }
                    AccessionID cdsAccessionID = new AccessionID((String)cdsName);
                    transcriptSequence.addCDS(cdsAccessionID, cdsFeature.location().bioStart(), cdsFeature.location().bioEnd(), frame);
                }
            }
        }
    }

    public static LinkedHashMap<String, ProteinSequence> getProteinSequences(Collection<ChromosomeSequence> chromosomeSequences) throws Exception {
        LinkedHashMap<String, ProteinSequence> proteinSequenceHashMap = new LinkedHashMap<String, ProteinSequence>();
        for (ChromosomeSequence dnaSequence : chromosomeSequences) {
            for (GeneSequence geneSequence : dnaSequence.getGeneSequences().values()) {
                for (TranscriptSequence transcriptSequence : geneSequence.getTranscripts().values()) {
                    try {
                        ProteinSequence proteinSequence = transcriptSequence.getProteinSequence();
                        if (proteinSequenceHashMap.containsKey(proteinSequence.getAccession().getID())) {
                            throw new Exception("Duplicate protein sequence id=" + proteinSequence.getAccession().getID() + " found at Gene id=" + geneSequence.getAccession().getID());
                        }
                        proteinSequenceHashMap.put(proteinSequence.getAccession().getID(), proteinSequence);
                    }
                    catch (Exception e) {
                        logger.error("Exception: ", (Throwable)e);
                    }
                }
            }
        }
        return proteinSequenceHashMap;
    }

    public static LinkedHashMap<String, GeneSequence> getGeneSequences(Collection<ChromosomeSequence> chromosomeSequences) throws Exception {
        LinkedHashMap<String, GeneSequence> geneSequenceHashMap = new LinkedHashMap<String, GeneSequence>();
        for (ChromosomeSequence chromosomeSequence : chromosomeSequences) {
            for (GeneSequence geneSequence : chromosomeSequence.getGeneSequences().values()) {
                geneSequenceHashMap.put(geneSequence.getAccession().getID(), geneSequence);
            }
        }
        return geneSequenceHashMap;
    }

    public static void main(String[] args) throws Exception {
    }
}

