/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.phylo;

import org.biojava.nbio.phylo.TreeConstructorType;
import org.biojava.nbio.phylo.TreeType;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.phylogeny.Phylogeny;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeConstructor {
    private static final Logger logger = LoggerFactory.getLogger(TreeConstructor.class);

    private TreeConstructor() {
    }

    public static Phylogeny distanceTree(BasicSymmetricalDistanceMatrix distM, TreeConstructorType constructor) {
        Phylogeny p = null;
        switch (constructor) {
            case NJ: {
                NeighborJoining nj = NeighborJoining.createInstance();
                p = nj.execute(distM);
                p.setType(TreeType.DISTANCE.name);
                break;
            }
            default: {
                logger.warn("Only NJ Tree Constructor Supported!");
            }
        }
        logger.info("Tree Completed");
        return p;
    }
}

