/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.web.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beetlframework.FrameworkConstant;
import org.beetlframework.InstanceFactory;
import org.beetlframework.mvc.Handler;
import org.beetlframework.mvc.HandlerExceptionResolver;
import org.beetlframework.mvc.HandlerInvoker;
import org.beetlframework.mvc.HandlerMapping;
import org.beetlframework.mvc.ServletActionContext;
import org.beetlframework.mvc.UploadHelper;
import org.beetlframework.util.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(urlPatterns={"/*"}, loadOnStartup=0)
public class DispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = -2594174767874048587L;
    private static final Logger logger = LoggerFactory.getLogger(DispatcherServlet.class);
    private HandlerMapping handlerMapping = InstanceFactory.getHandlerMapping();
    private HandlerInvoker handlerInvoker = InstanceFactory.getHandlerInvoker();
    private HandlerExceptionResolver handlerExceptionResolver = InstanceFactory.getHandlerExceptionResolver();

    public void init(ServletConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        UploadHelper.init(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Handler handler;
        request.setCharacterEncoding(FrameworkConstant.ENCODING);
        String currentRequestMethod = this.getRequestMethod(request);
        String currentRequestPath = WebUtil.getRequestPath(request);
        logger.debug("[beetl] {}:{}", (Object)currentRequestMethod, (Object)currentRequestPath);
        if (currentRequestPath.equals("/")) {
            WebUtil.redirectRequest(FrameworkConstant.HOME_PAGE, request, response);
            return;
        }
        if (currentRequestPath.endsWith("/")) {
            currentRequestPath = currentRequestPath.substring(0, currentRequestPath.length() - 1);
        }
        if ((handler = this.handlerMapping.getHandler(currentRequestMethod, currentRequestPath)) == null) {
            WebUtil.sendError(404, "", response);
            return;
        }
        ServletActionContext.init(request, response);
        try {
            this.handlerInvoker.invokeHandler(request, response, handler);
        }
        catch (Exception e) {
            this.handlerExceptionResolver.resolveHandlerException(request, response, e);
        }
        finally {
            ServletActionContext.destroy();
        }
    }

    private String getRequestMethod(HttpServletRequest request) {
        String method = request.getMethod();
        if ("POST".equals(method) || "GET".equals(method)) {
            return "Action";
        }
        return method;
    }
}

