/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.web.context;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebListener;
import org.beetlframework.BeetlContext;
import org.beetlframework.ContainerLoader;
import org.beetlframework.FrameworkConstant;
import org.beetlframework.plugin.Plugin;
import org.beetlframework.plugin.PluginHelper;
import org.beetlframework.plugin.WebPlugin;
import org.beetlframework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ContextLoaderListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(ServletContextListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        ContainerLoader.init();
        this.addServletMapping(servletContext);
        this.registerWebPlugin(servletContext);
        this.loaderBeetl(servletContext);
    }

    private void loaderBeetl(ServletContext servletContext) {
        String root = servletContext.getRealPath("");
        BeetlContext.initCtx(root);
        logger.info("[beetl] \u8fd0\u884c\u73af\u5883\u521d\u59cb\u5316\u5b8c\u6210");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.destroyPlugin();
    }

    private void addServletMapping(ServletContext context) {
        this.registerDefaultServlet(context);
        this.registerJspServlet(context);
    }

    private void registerDefaultServlet(ServletContext context) {
        ServletRegistration defaultServlet = context.getServletRegistration("default");
        defaultServlet.addMapping(new String[]{"/index.html"});
        defaultServlet.addMapping(new String[]{"/favicon.ico"});
        String wwwPath = FrameworkConstant.WWW_PATH;
        if (StringUtil.isNotEmpty(wwwPath)) {
            defaultServlet.addMapping(new String[]{wwwPath + "*"});
        }
    }

    private void registerJspServlet(ServletContext context) {
        ServletRegistration jspServlet = context.getServletRegistration("jsp");
        jspServlet.addMapping(new String[]{"/index.jsp"});
        String jspPath = FrameworkConstant.JSP_PATH;
        if (StringUtil.isNotEmpty(jspPath)) {
            jspServlet.addMapping(new String[]{jspPath + "*"});
        }
    }

    private void registerWebPlugin(ServletContext servletContext) {
        List<Plugin> pluginList = PluginHelper.getPluginList();
        for (Plugin plugin : pluginList) {
            if (!(plugin instanceof WebPlugin)) continue;
            WebPlugin webPlugin = (WebPlugin)plugin;
            webPlugin.register(servletContext);
        }
    }

    private void destroyPlugin() {
        List<Plugin> pluginList = PluginHelper.getPluginList();
        for (Plugin plugin : pluginList) {
            plugin.destroy();
        }
    }
}

