/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.beetlframework.FrameworkConstant;
import org.beetlframework.util.ArrayUtil;
import org.beetlframework.util.CodecUtil;
import org.beetlframework.util.JsonUtil;
import org.beetlframework.util.StreamUtil;
import org.beetlframework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtil {
    private static final Logger logger = LoggerFactory.getLogger(WebUtil.class);

    public static void writeJSON(HttpServletResponse response, Object data) {
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding(FrameworkConstant.ENCODING);
            PrintWriter writer = response.getWriter();
            writer.write(JsonUtil.toJSON(data));
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            logger.error("\u5728\u54cd\u5e94\u4e2d\u5199\u6570\u636e\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void writeHTML(HttpServletResponse response, Object data) {
        try {
            response.setContentType("text/html");
            response.setCharacterEncoding(FrameworkConstant.ENCODING);
            PrintWriter writer = response.getWriter();
            writer.write(JsonUtil.toJSON(data));
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            logger.error("\u5728\u54cd\u5e94\u4e2d\u5199\u6570\u636e\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> getRequestParamMap(HttpServletRequest request) {
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
        try {
            String method = request.getMethod();
            if (method.equalsIgnoreCase("put") || method.equalsIgnoreCase("delete")) {
                Object[] qsArray;
                String queryString = CodecUtil.decodeURL(StreamUtil.getString((InputStream)request.getInputStream()));
                if (StringUtil.isNotEmpty(queryString) && ArrayUtil.isNotEmpty(qsArray = StringUtil.splitString(queryString, "&"))) {
                    for (Object qs : qsArray) {
                        Object[] array = StringUtil.splitString((String)qs, "=");
                        if (!ArrayUtil.isNotEmpty(array) || array.length != 2) continue;
                        Object paramName = array[0];
                        Object paramValue = array[1];
                        if (!WebUtil.checkParamName((String)paramName)) continue;
                        if (paramMap.containsKey(paramName)) {
                            paramValue = paramMap.get(paramName) + StringUtil.SEPARATOR + (String)paramValue;
                        }
                        paramMap.put((String)paramName, paramValue);
                    }
                }
            } else {
                Enumeration paramNames = request.getParameterNames();
                while (paramNames.hasMoreElements()) {
                    Object[] paramValues;
                    String paramName = (String)paramNames.nextElement();
                    if (!WebUtil.checkParamName(paramName) || !ArrayUtil.isNotEmpty(paramValues = request.getParameterValues(paramName))) continue;
                    if (paramValues.length == 1) {
                        paramMap.put(paramName, paramValues[0]);
                        continue;
                    }
                    StringBuilder paramValue = new StringBuilder("");
                    for (int i = 0; i < paramValues.length; ++i) {
                        paramValue.append((String)paramValues[i]);
                        if (i == paramValues.length - 1) continue;
                        paramValue.append(StringUtil.SEPARATOR);
                    }
                    paramMap.put(paramName, paramValue.toString());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return paramMap;
    }

    private static boolean checkParamName(String paramName) {
        return !paramName.equals("_");
    }

    public static void forwardRequest(String path, HttpServletRequest request, HttpServletResponse response) {
        try {
            request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            logger.error("\u8f6c\u53d1\u8bf7\u6c42\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void redirectRequest(String path, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.sendRedirect(request.getContextPath() + path);
        }
        catch (Exception e) {
            logger.error("\u91cd\u5b9a\u5411\u8bf7\u6c42\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void sendError(int code, String message, HttpServletResponse response) {
        try {
            response.sendError(code, message);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u9519\u8bef\u4ee3\u7801\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isAJAX(HttpServletRequest request) {
        return request.getHeader("X-Requested-With") != null;
    }

    public static String getRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = StringUtil.defaultIfEmpty(request.getPathInfo(), "");
        return servletPath + pathInfo;
    }

    public static String getCookie(HttpServletRequest request, String name) {
        String value;
        block3: {
            value = "";
            try {
                Cookie[] cookieArray = request.getCookies();
                if (cookieArray == null) break block3;
                for (Cookie cookie : cookieArray) {
                    if (!StringUtil.isNotEmpty(name) || !name.equals(cookie.getName())) continue;
                    value = CodecUtil.decodeURL(cookie.getValue());
                    break;
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6 Cookie \u51fa\u9519\uff01", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    public static void downloadFile(HttpServletResponse response, String filePath) {
        try {
            String originalFileName = FilenameUtils.getName((String)filePath);
            String downloadedFileName = new String(originalFileName.getBytes("GBK"), "ISO8859_1");
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Disposition", "attachment;filename=\"" + downloadedFileName + "\"");
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(filePath));
            BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            StreamUtil.copyStream(inputStream, outputStream);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void setRedirectUrl(HttpServletRequest request, String sessionKey) {
        if (!WebUtil.isAJAX(request)) {
            String requestPath = WebUtil.getRequestPath(request);
            request.getSession().setAttribute(sessionKey, (Object)requestPath);
        }
    }

    public static String createCaptcha(HttpServletResponse response) {
        StringBuilder captcha = new StringBuilder();
        try {
            int width = 60;
            int height = 25;
            int codeCount = 4;
            int codeX = width / (codeCount + 1);
            int codeY = height - 4;
            int fontHeight = height - 2;
            int randomSeed = 10;
            char[] codeSequence = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics2D g = bi.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, width, height);
            g.setFont(new Font("Courier New", 1, fontHeight));
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, width - 1, height - 1);
            g.setColor(Color.WHITE);
            Random random = new Random();
            for (int i = 0; i < 160; ++i) {
                int x = random.nextInt(width);
                int y = random.nextInt(height);
                int xl = random.nextInt(12);
                int yl = random.nextInt(12);
                g.drawLine(x, y, x + xl, y + yl);
            }
            for (int i = 0; i < codeCount; ++i) {
                String validateCode = String.valueOf(codeSequence[random.nextInt(randomSeed)]);
                int red = random.nextInt(255);
                int green = random.nextInt(255);
                int blue = random.nextInt(255);
                g.setColor(new Color(red, green, blue));
                g.drawString(validateCode, (i + 1) * codeX - 6, codeY);
                captcha.append(validateCode);
            }
            response.setHeader("Cache-Control", "no-store");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setContentType("image/jpeg");
            ServletOutputStream sos = response.getOutputStream();
            ImageIO.write((RenderedImage)bi, "jpeg", (OutputStream)sos);
            sos.close();
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u9a8c\u8bc1\u7801\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return captcha.toString();
    }

    public boolean isIE(HttpServletRequest request) {
        String agent = request.getHeader("User-Agent");
        return agent != null && agent.contains("MSIE");
    }
}

