/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtil {
    private static final Logger logger = LoggerFactory.getLogger(StreamUtil.class);

    public static void copyStream(InputStream inputStream, OutputStream outputStream) {
        try {
            int length;
            byte[] buffer = new byte[4096];
            while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            logger.error("\u590d\u5236\u6d41\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (Exception e) {
                logger.error("\u91ca\u653e\u8d44\u6e90\u51fa\u9519\uff01", (Throwable)e);
            }
        }
    }

    public static String getString(InputStream is) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            logger.error("Stream \u8f6c String \u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return sb.toString();
    }
}

