/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.beetlframework.util.CastUtil;
import org.beetlframework.util.ClassLoaderUtil;
import org.beetlframework.util.CollectionUtil;
import org.beetlframework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropsUtil {
    private static final Logger logger = LoggerFactory.getLogger(PropsUtil.class);

    public static Properties loadProps(String propsPath) {
        Properties props = new Properties();
        InputStream is = null;
        try {
            if (StringUtil.isEmpty(propsPath)) {
                throw new IllegalArgumentException();
            }
            String suffix = ".properties";
            if (propsPath.lastIndexOf(suffix) == -1) {
                propsPath = propsPath + suffix;
            }
            if ((is = ClassLoaderUtil.getClassLoader().getResourceAsStream(propsPath)) != null) {
                props.load(is);
            }
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u5c5e\u6027\u6587\u4ef6\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error("\u91ca\u653e\u8d44\u6e90\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        return props;
    }

    public static Map<String, String> loadPropsToMap(String propsPath) {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties props = PropsUtil.loadProps(propsPath);
        for (String key : props.stringPropertyNames()) {
            map.put(key, props.getProperty(key));
        }
        return map;
    }

    public static String getString(Properties props, String key) {
        String value = "";
        if (props.containsKey(key)) {
            value = props.getProperty(key);
        }
        return value;
    }

    public static String getString(Properties props, String key, String defalutValue) {
        String value = defalutValue;
        if (props.containsKey(key)) {
            value = props.getProperty(key);
        }
        return value;
    }

    public static int getNumber(Properties props, String key) {
        int value = 0;
        if (props.containsKey(key)) {
            value = CastUtil.castInt(props.getProperty(key));
        }
        return value;
    }

    public static int getNumber(Properties props, String key, int defaultValue) {
        int value = defaultValue;
        if (props.containsKey(key)) {
            value = CastUtil.castInt(props.getProperty(key));
        }
        return value;
    }

    public static boolean getBoolean(Properties props, String key) {
        return PropsUtil.getBoolean(props, key, false);
    }

    public static boolean getBoolean(Properties props, String key, boolean defalutValue) {
        boolean value = defalutValue;
        if (props.containsKey(key)) {
            value = CastUtil.castBoolean(props.getProperty(key));
        }
        return value;
    }

    public static Map<String, Object> getMap(Properties props, String prefix) {
        LinkedHashMap<String, Object> kvMap = new LinkedHashMap<String, Object>();
        Set<String> keySet = props.stringPropertyNames();
        if (CollectionUtil.isNotEmpty(keySet)) {
            for (String key : keySet) {
                if (!key.startsWith(prefix)) continue;
                String value = props.getProperty(key);
                kvMap.put(key, value);
            }
        }
        return kvMap;
    }
}

