/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.beetlframework.util.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtil {
    private static final Logger logger = LoggerFactory.getLogger(ObjectUtil.class);

    public static void setField(Object obj, String fieldName, Object fieldValue) {
        try {
            if (PropertyUtils.isWriteable((Object)obj, (String)fieldName)) {
                PropertyUtils.setProperty((Object)obj, (String)fieldName, (Object)fieldValue);
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u6210\u5458\u53d8\u91cf\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Object propertyValue = null;
        try {
            if (PropertyUtils.isReadable((Object)obj, (String)fieldName)) {
                propertyValue = PropertyUtils.getProperty((Object)obj, (String)fieldName);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6210\u5458\u53d8\u91cf\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return propertyValue;
    }

    public static void copyFields(Object source, Object target) {
        try {
            for (Field field : source.getClass().getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                field.set(target, field.get(source));
            }
        }
        catch (Exception e) {
            logger.error("\u590d\u5236\u6210\u5458\u53d8\u91cf\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(String className) {
        Object instance;
        try {
            Class<?> commandClass = ClassLoaderUtil.loadClass(className);
            instance = commandClass.newInstance();
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5b9e\u4f8b\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return (T)instance;
    }

    public static Map<String, Object> getFieldMap(Object obj) {
        return ObjectUtil.getFieldMap(obj, true);
    }

    public static Map<String, Object> getFieldMap(Object obj, boolean isStaticIgnored) {
        Field[] fields;
        LinkedHashMap<String, Object> fieldMap = new LinkedHashMap<String, Object>();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            if (isStaticIgnored && Modifier.isStatic(field.getModifiers())) continue;
            String fieldName = field.getName();
            Object fieldValue = ObjectUtil.getFieldValue(obj, fieldName);
            fieldMap.put(fieldName, fieldValue);
        }
        return fieldMap;
    }
}

