/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.util;

import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> String toJSON(T obj) {
        String jsonStr;
        try {
            jsonStr = objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.error("Java \u8f6c JSON \u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return jsonStr;
    }

    public static <T> T fromJSON(String json, Class<T> type) {
        Object obj;
        try {
            obj = objectMapper.readValue(json, type);
        }
        catch (Exception e) {
            logger.error("JSON \u8f6c Java \u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return (T)obj;
    }
}

