/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.beetlframework.FrameworkConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static File createDir(String dirPath) {
        File dir;
        try {
            dir = new File(dirPath);
            if (!dir.exists()) {
                FileUtils.forceMkdir((File)dir);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u76ee\u5f55\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return dir;
    }

    public static File createFile(String filePath) {
        File file;
        try {
            file = new File(filePath);
            File parentDir = file.getParentFile();
            if (!parentDir.exists()) {
                FileUtils.forceMkdir((File)parentDir);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u6587\u4ef6\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return file;
    }

    public static void copyDir(String srcPath, String destPath) {
        try {
            File srcDir = new File(srcPath);
            File destDir = new File(destPath);
            if (srcDir.exists() && srcDir.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
            }
        }
        catch (Exception e) {
            logger.error("\u590d\u5236\u76ee\u5f55\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void copyFile(String srcPath, String destPath) {
        try {
            File srcFile = new File(srcPath);
            File destDir = new File(destPath);
            if (srcFile.exists() && srcFile.isFile()) {
                FileUtils.copyFileToDirectory((File)srcFile, (File)destDir);
            }
        }
        catch (Exception e) {
            logger.error("\u590d\u5236\u6587\u4ef6\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void deleteDir(String dirPath) {
        try {
            File dir = new File(dirPath);
            if (dir.exists() && dir.isDirectory()) {
                FileUtils.deleteDirectory((File)dir);
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u76ee\u5f55\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void deleteFile(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists() && file.isFile()) {
                FileUtils.forceDelete((File)file);
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6587\u4ef6\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void renameFile(String srcPath, String destPath) {
        File newFile;
        boolean result;
        File srcFile = new File(srcPath);
        if (srcFile.exists() && !(result = srcFile.renameTo(newFile = new File(destPath)))) {
            throw new RuntimeException("\u91cd\u547d\u540d\u6587\u4ef6\u51fa\u9519\uff01" + newFile);
        }
    }

    public static void writeFile(String filePath, String fileContent) {
        OutputStream os = null;
        Writer w = null;
        try {
            FileUtil.createFile(filePath);
            os = new BufferedOutputStream(new FileOutputStream(filePath));
            w = new OutputStreamWriter(os, FrameworkConstant.ENCODING);
            w.write(fileContent);
            w.flush();
        }
        catch (Exception e) {
            logger.error("\u5199\u5165\u6587\u4ef6\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (w != null) {
                    w.close();
                }
            }
            catch (Exception e) {
                logger.error("\u91ca\u653e\u8d44\u6e90\u51fa\u9519\uff01", (Throwable)e);
            }
        }
    }

    public static String getRealFileName(String fileName) {
        return FilenameUtils.getName((String)fileName);
    }

    public static boolean checkFileExists(String filePath) {
        return new File(filePath).exists();
    }
}

