/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    private static final SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");

    public static String formatDatetime(long timestamp) {
        return datetimeFormat.format(new Date(timestamp));
    }

    public static String formatDate(long timestamp) {
        return dateFormat.format(new Date(timestamp));
    }

    public static String formatTime(long timestamp) {
        return timeFormat.format(new Date(timestamp));
    }

    public static String getCurrentDatetime() {
        return datetimeFormat.format(new Date());
    }

    public static String getCurrentDate() {
        return dateFormat.format(new Date());
    }

    public static String getCurrentTime() {
        return timeFormat.format(new Date());
    }

    public static Date parseDatetime(String str) {
        Date date = null;
        try {
            date = datetimeFormat.parse(str);
        }
        catch (ParseException e) {
            logger.error("\u89e3\u6790\u65e5\u671f\u5b57\u7b26\u4e32\u51fa\u9519\uff01\u683c\u5f0f\uff1ayyyy-MM-dd HH:mm:ss", (Throwable)e);
        }
        return date;
    }

    public static Date parseDate(String str) {
        Date date = null;
        try {
            date = dateFormat.parse(str);
        }
        catch (ParseException e) {
            logger.error("\u89e3\u6790\u65e5\u671f\u5b57\u7b26\u4e32\u51fa\u9519\uff01\u683c\u5f0f\uff1ayyyy-MM-dd", (Throwable)e);
        }
        return date;
    }

    public static Date parseTime(String str) {
        Date date = null;
        try {
            date = timeFormat.parse(str);
        }
        catch (ParseException e) {
            logger.error("\u89e3\u6790\u65e5\u671f\u5b57\u7b26\u4e32\u51fa\u9519\uff01\u683c\u5f0f\uff1aHH:mm:ss", (Throwable)e);
        }
        return date;
    }
}

