/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.beetlframework.FrameworkConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecUtil {
    private static final Logger logger = LoggerFactory.getLogger(CodecUtil.class);

    public static String encodeURL(String str) {
        String target;
        try {
            target = URLEncoder.encode(str, FrameworkConstant.ENCODING);
        }
        catch (Exception e) {
            logger.error("\u7f16\u7801\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return target;
    }

    public static String decodeURL(String str) {
        String target;
        try {
            target = URLDecoder.decode(str, FrameworkConstant.ENCODING);
        }
        catch (Exception e) {
            logger.error("\u89e3\u7801\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return target;
    }

    public static String encodeBASE64(String str) {
        String target;
        try {
            target = Base64.encodeBase64URLSafeString((byte[])str.getBytes(FrameworkConstant.ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u7f16\u7801\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return target;
    }

    public static String decodeBASE64(String str) {
        String target;
        try {
            target = new String(Base64.decodeBase64((String)str), FrameworkConstant.ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u89e3\u7801\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        return target;
    }

    public static String encryptMD5(String str) {
        return DigestUtils.md5Hex((String)str);
    }

    public static String encryptSHA(String str) {
        return DigestUtils.sha1Hex((String)str);
    }

    public static String createRandom(int count) {
        return RandomStringUtils.randomNumeric((int)count);
    }

    public static String createUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

