/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.util;

import org.beetlframework.util.ArrayUtil;
import org.beetlframework.util.StringUtil;

public class CastUtil {
    public static String castString(Object obj) {
        return CastUtil.castString(obj, "");
    }

    public static String castString(Object obj, String defaultValue) {
        return obj != null ? String.valueOf(obj) : defaultValue;
    }

    public static double castDouble(Object obj) {
        return CastUtil.castDouble(obj, 0.0);
    }

    public static double castDouble(Object obj, double defaultValue) {
        String strValue;
        double doubleValue = defaultValue;
        if (obj != null && StringUtil.isNotEmpty(strValue = CastUtil.castString(obj))) {
            try {
                doubleValue = Double.parseDouble(strValue);
            }
            catch (NumberFormatException e) {
                doubleValue = defaultValue;
            }
        }
        return doubleValue;
    }

    public static long castLong(Object obj) {
        return CastUtil.castLong(obj, 0L);
    }

    public static long castLong(Object obj, long defaultValue) {
        String strValue;
        long longValue = defaultValue;
        if (obj != null && StringUtil.isNotEmpty(strValue = CastUtil.castString(obj))) {
            try {
                longValue = Long.parseLong(strValue);
            }
            catch (NumberFormatException e) {
                longValue = defaultValue;
            }
        }
        return longValue;
    }

    public static int castInt(Object obj) {
        return CastUtil.castInt(obj, 0);
    }

    public static int castInt(Object obj, int defaultValue) {
        String strValue;
        int intValue = defaultValue;
        if (obj != null && StringUtil.isNotEmpty(strValue = CastUtil.castString(obj))) {
            try {
                intValue = Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                intValue = defaultValue;
            }
        }
        return intValue;
    }

    public static boolean castBoolean(Object obj) {
        return CastUtil.castBoolean(obj, false);
    }

    public static boolean castBoolean(Object obj, boolean defaultValue) {
        boolean booleanValue = defaultValue;
        if (obj != null) {
            booleanValue = Boolean.parseBoolean(CastUtil.castString(obj));
        }
        return booleanValue;
    }

    public static String[] castStringArray(Object[] objArray) {
        if (objArray == null) {
            objArray = new Object[]{};
        }
        String[] strArray = new String[objArray.length];
        if (ArrayUtil.isNotEmpty(objArray)) {
            for (int i = 0; i < objArray.length; ++i) {
                strArray[i] = CastUtil.castString(objArray[i]);
            }
        }
        return strArray;
    }

    public static double[] castDoubleArray(Object[] objArray) {
        if (objArray == null) {
            objArray = new Object[]{};
        }
        double[] doubleArray = new double[objArray.length];
        if (!ArrayUtil.isEmpty(objArray)) {
            for (int i = 0; i < objArray.length; ++i) {
                doubleArray[i] = CastUtil.castDouble(objArray[i]);
            }
        }
        return doubleArray;
    }

    public static long[] castLongArray(Object[] objArray) {
        if (objArray == null) {
            objArray = new Object[]{};
        }
        long[] longArray = new long[objArray.length];
        if (!ArrayUtil.isEmpty(objArray)) {
            for (int i = 0; i < objArray.length; ++i) {
                longArray[i] = CastUtil.castLong(objArray[i]);
            }
        }
        return longArray;
    }

    public static int[] castIntArray(Object[] objArray) {
        if (objArray == null) {
            objArray = new Object[]{};
        }
        int[] intArray = new int[objArray.length];
        if (!ArrayUtil.isEmpty(objArray)) {
            for (int i = 0; i < objArray.length; ++i) {
                intArray[i] = CastUtil.castInt(objArray[i]);
            }
        }
        return intArray;
    }

    public static boolean[] castBooleanArray(Object[] objArray) {
        if (objArray == null) {
            objArray = new Object[]{};
        }
        boolean[] booleanArray = new boolean[objArray.length];
        if (!ArrayUtil.isEmpty(objArray)) {
            for (int i = 0; i < objArray.length; ++i) {
                booleanArray[i] = CastUtil.castBoolean(objArray[i]);
            }
        }
        return booleanArray;
    }
}

