/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.mvc.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beetlframework.FrameworkConstant;
import org.beetlframework.mvc.UploadHelper;
import org.beetlframework.mvc.ViewResolver;
import org.beetlframework.mvc.bean.Result;
import org.beetlframework.mvc.bean.View;
import org.beetlframework.util.MapUtil;
import org.beetlframework.util.WebUtil;

public class DefaultViewResolver
implements ViewResolver {
    @Override
    public void resolveView(HttpServletRequest request, HttpServletResponse response, Object actionMethodResult) {
        if (actionMethodResult != null) {
            if (actionMethodResult instanceof View) {
                View view = (View)actionMethodResult;
                if (view.isRedirect()) {
                    String path = view.getPath();
                    WebUtil.redirectRequest(path, request, response);
                } else {
                    String path = FrameworkConstant.JSP_PATH + view.getPath();
                    Map<String, Object> data = view.getData();
                    if (MapUtil.isNotEmpty(data)) {
                        for (Map.Entry<String, Object> entry : data.entrySet()) {
                            request.setAttribute(entry.getKey(), entry.getValue());
                        }
                    }
                    WebUtil.forwardRequest(path, request, response);
                }
            } else {
                Result result = (Result)actionMethodResult;
                if (UploadHelper.isMultipart(request)) {
                    WebUtil.writeHTML(response, result);
                } else {
                    WebUtil.writeJSON(response, result);
                }
            }
        }
    }
}

