/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.mvc.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beetlframework.InstanceFactory;
import org.beetlframework.ioc.BeanContext;
import org.beetlframework.mvc.Handler;
import org.beetlframework.mvc.HandlerInvoker;
import org.beetlframework.mvc.UploadHelper;
import org.beetlframework.mvc.ViewResolver;
import org.beetlframework.mvc.bean.Params;
import org.beetlframework.util.CastUtil;
import org.beetlframework.util.ClassLoaderUtil;
import org.beetlframework.util.MapUtil;
import org.beetlframework.util.WebUtil;

public class DefaultHandlerInvoker
implements HandlerInvoker {
    private ViewResolver viewResolver = InstanceFactory.getViewResolver();

    @Override
    public void invokeHandler(HttpServletRequest request, HttpServletResponse response, Handler handler) throws Exception {
        Class<?> actionClass = handler.getActionClass();
        Method actionMethod = handler.getActionMethod();
        Object actionInstance = BeanContext.getBean(actionClass);
        List<Object> actionMethodParamList = this.createActionMethodParamList(request, handler);
        this.checkParamList(actionMethod, actionMethodParamList);
        Object actionMethodResult = this.invokeActionMethod(actionMethod, actionInstance, actionMethodParamList);
        this.viewResolver.resolveView(request, response, actionMethodResult);
    }

    public List<Object> createActionMethodParamList(HttpServletRequest request, Handler handler) throws Exception {
        ArrayList<Object> paramList = new ArrayList<Object>();
        Class<?>[] actionParamTypes = handler.getActionMethod().getParameterTypes();
        paramList.addAll(this.createPathParamList(handler.getRequestPathMatcher(), actionParamTypes));
        if (UploadHelper.isMultipart(request)) {
            paramList.addAll(UploadHelper.createMultipartParamList(request));
        } else {
            Map<String, Object> requestParamMap = WebUtil.getRequestParamMap(request);
            if (MapUtil.isNotEmpty(requestParamMap)) {
                paramList.add(new Params(requestParamMap));
            }
        }
        return paramList;
    }

    private List<Object> createPathParamList(Matcher requestPathMatcher, Class<?>[] actionParamTypes) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (int i = 1; i <= requestPathMatcher.groupCount(); ++i) {
            String param = requestPathMatcher.group(i);
            Class<?> paramType = actionParamTypes[i - 1];
            if (ClassLoaderUtil.isInt(paramType)) {
                paramList.add(CastUtil.castInt(param));
                continue;
            }
            if (ClassLoaderUtil.isLong(paramType)) {
                paramList.add(CastUtil.castLong(param));
                continue;
            }
            if (ClassLoaderUtil.isDouble(paramType)) {
                paramList.add(CastUtil.castDouble(param));
                continue;
            }
            if (!ClassLoaderUtil.isString(paramType)) continue;
            paramList.add(param);
        }
        return paramList;
    }

    private Object invokeActionMethod(Method actionMethod, Object actionInstance, List<Object> actionMethodParamList) throws IllegalAccessException, InvocationTargetException {
        actionMethod.setAccessible(true);
        return actionMethod.invoke(actionInstance, actionMethodParamList.toArray());
    }

    private void checkParamList(Method actionMethod, List<Object> actionMethodParamList) {
        Class<?>[] actionMethodParameterTypes = actionMethod.getParameterTypes();
        if (actionMethodParameterTypes.length != actionMethodParamList.size()) {
            String message = String.format("\u56e0\u4e3a\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d\uff0c\u6240\u4ee5\u65e0\u6cd5\u8c03\u7528 Action \u65b9\u6cd5\uff01\u539f\u59cb\u53c2\u6570\u4e2a\u6570\uff1a%d\uff0c\u5b9e\u9645\u53c2\u6570\u4e2a\u6570\uff1a%d", actionMethodParameterTypes.length, actionMethodParamList.size());
            throw new RuntimeException(message);
        }
    }
}

