/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.mvc.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beetlframework.FrameworkConstant;
import org.beetlframework.fault.AuthcException;
import org.beetlframework.fault.AuthzException;
import org.beetlframework.mvc.HandlerExceptionResolver;
import org.beetlframework.util.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHandlerExceptionResolver
implements HandlerExceptionResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHandlerExceptionResolver.class);

    @Override
    public void resolveHandlerException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        if (cause instanceof AuthcException) {
            if (WebUtil.isAJAX(request)) {
                WebUtil.sendError(403, "", response);
            } else {
                WebUtil.redirectRequest(FrameworkConstant.HOME_PAGE, request, response);
            }
        } else if (cause instanceof AuthzException) {
            WebUtil.sendError(403, "", response);
        } else {
            WebUtil.sendError(500, cause.getMessage(), response);
        }
    }
}

