/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.mvc.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beetl.core.GroupTemplate;
import org.beetl.ext.web.WebRender;
import org.beetlframework.BeetlContext;
import org.beetlframework.FrameworkConstant;
import org.beetlframework.mvc.UploadHelper;
import org.beetlframework.mvc.ViewResolver;
import org.beetlframework.mvc.bean.Result;
import org.beetlframework.mvc.bean.View;
import org.beetlframework.util.MapUtil;
import org.beetlframework.util.WebUtil;

public class BeetlViewResolver
implements ViewResolver {
    private static final transient String encoding = FrameworkConstant.ENCODING;
    private static final transient String contentType = "text/html; charset=" + encoding;

    @Override
    public void resolveView(HttpServletRequest request, HttpServletResponse response, Object actionMethodResult) {
        if (actionMethodResult == null) {
            return;
        }
        if (actionMethodResult instanceof View) {
            View view = (View)actionMethodResult;
            this.processView(request, response, view);
        } else if (actionMethodResult instanceof Result) {
            Result result = (Result)actionMethodResult;
            this.processResult(request, response, result);
        } else {
            throw new RuntimeException("action\u65b9\u6cd5\u8fd4\u56de\u503c\u4e0d\u4e3aView\u6216Result\u7c7b\u578b");
        }
    }

    private void processView(HttpServletRequest request, HttpServletResponse response, View view) {
        if (view.isRedirect()) {
            String path = view.getPath();
            WebUtil.redirectRequest(path, request, response);
        } else {
            Map<String, Object> data = view.getData();
            if (MapUtil.isNotEmpty(data)) {
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    request.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            String path = view.getPath();
            response.setContentType(contentType);
            GroupTemplate gt = BeetlContext.getGroupTemplate();
            WebRender webRender = new WebRender(gt);
            webRender.render(path, request, response, new Object[0]);
        }
    }

    private void processResult(HttpServletRequest request, HttpServletResponse response, Result result) {
        if (UploadHelper.isMultipart(request)) {
            WebUtil.writeHTML(response, result);
        } else {
            WebUtil.writeJSON(response, result);
        }
    }
}

