/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.mvc.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beetlframework.InstanceFactory;
import org.beetlframework.ioc.BeanContext;
import org.beetlframework.mvc.Handler;
import org.beetlframework.mvc.HandlerInvoker;
import org.beetlframework.mvc.ViewResolver;

public class BeetlHandlerInvoker
implements HandlerInvoker {
    private ViewResolver viewResolver = InstanceFactory.getViewResolver();

    @Override
    public void invokeHandler(HttpServletRequest request, HttpServletResponse response, Handler handler) throws Exception {
        Class<?> actionClass = handler.getActionClass();
        Method actionMethod = handler.getActionMethod();
        Object actionInstance = BeanContext.getBean(actionClass);
        this.checkParamList(actionMethod);
        Object actionMethodResult = this.invokeActionMethod(actionMethod, actionInstance);
        this.viewResolver.resolveView(request, response, actionMethodResult);
    }

    private void checkParamList(Method actionMethod) {
        Class<?>[] actionMethodParameterTypes = actionMethod.getParameterTypes();
        if (actionMethodParameterTypes.length > 0) {
            String method = actionMethod.getDeclaringClass().getName() + "." + actionMethod.getName() + "(...)";
            String message = String.format("\u63a7\u5236\u5c42Action\u65b9\u6cd5\u4e0d\u9700\u8981\u53c2\u6570\uff0c\u4f60\u5728%s\u65b9\u6cd5\u5b9a\u4e49\u4e86%d\u4e2a\u53c2\u6570", method, actionMethodParameterTypes.length);
            throw new RuntimeException(message);
        }
    }

    private Object invokeActionMethod(Method actionMethod, Object actionInstance) throws IllegalAccessException, InvocationTargetException {
        actionMethod.setAccessible(true);
        return actionMethod.invoke(actionInstance, new Object[0]);
    }
}

