/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.mvc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.beetlframework.FrameworkConstant;
import org.beetlframework.fault.UploadException;
import org.beetlframework.mvc.bean.Multipart;
import org.beetlframework.mvc.bean.Multiparts;
import org.beetlframework.mvc.bean.Params;
import org.beetlframework.util.FileUtil;
import org.beetlframework.util.StreamUtil;
import org.beetlframework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadHelper {
    private static final Logger logger = LoggerFactory.getLogger(UploadHelper.class);
    private static ServletFileUpload fileUpload;

    public static void init(ServletContext servletContext) {
        File repository = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        logger.debug("[beetl] temp dir of uploading: {}", (Object)repository);
        fileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory(10240, repository));
        int uploadLimit = FrameworkConstant.UPLOAD_LIMIT;
        if (uploadLimit != 0) {
            fileUpload.setFileSizeMax((long)(uploadLimit * 1024 * 1024));
            logger.debug("[beetl] limit of uploading: {}M", (Object)uploadLimit);
        }
    }

    public static boolean isMultipart(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    public static List<Object> createMultipartParamList(HttpServletRequest request) throws Exception {
        List fileItemList;
        ArrayList<Object> paramList = new ArrayList<Object>();
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        ArrayList<Multipart> multipartList = new ArrayList<Multipart>();
        try {
            fileItemList = fileUpload.parseRequest(request);
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            throw new UploadException(e);
        }
        for (FileItem fileItem : fileItemList) {
            String fieldName = fileItem.getFieldName();
            if (fileItem.isFormField()) {
                String fieldValue = fileItem.getString(FrameworkConstant.ENCODING);
                fieldMap.put(fieldName, fieldValue);
                continue;
            }
            String fileName = FileUtil.getRealFileName(fileItem.getName());
            if (!StringUtil.isNotEmpty(fileName)) continue;
            long fileSize = fileItem.getSize();
            String contentType = fileItem.getContentType();
            InputStream inputSteam = fileItem.getInputStream();
            Multipart multipart = new Multipart(fieldName, fileName, fileSize, contentType, inputSteam);
            multipartList.add(multipart);
        }
        paramList.add(new Params(fieldMap));
        paramList.add(new Multiparts(multipartList));
        return paramList;
    }

    public static void uploadFile(String basePath, Multipart multipart) {
        try {
            if (multipart != null) {
                String filePath = basePath + multipart.getFileName();
                FileUtil.createFile(filePath);
                BufferedInputStream inputStream = new BufferedInputStream(multipart.getInputStream());
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(filePath));
                StreamUtil.copyStream(inputStream, outputStream);
            }
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void uploadFiles(String basePath, Multiparts multiparts) {
        for (Multipart multipart : multiparts.getAll()) {
            UploadHelper.uploadFile(basePath, multipart);
        }
    }
}

