/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.mvc;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.beetlframework.util.ArrayUtil;
import org.beetlframework.util.CastUtil;
import org.beetlframework.util.CodecUtil;

public class ServletActionContext {
    private static final ThreadLocal<ServletActionContext> dataContextContainer = new ThreadLocal();
    private HttpServletRequest request;
    private HttpServletResponse response;

    public static void init(HttpServletRequest request, HttpServletResponse response) {
        ServletActionContext dataContext = new ServletActionContext();
        dataContext.request = request;
        dataContext.response = response;
        dataContextContainer.set(dataContext);
    }

    public static void destroy() {
        dataContextContainer.remove();
    }

    public static ServletActionContext getInstance() {
        return dataContextContainer.get();
    }

    public static HttpServletRequest getRequest() {
        return ServletActionContext.getInstance().request;
    }

    public static HttpServletResponse getResponse() {
        return ServletActionContext.getInstance().response;
    }

    public static HttpSession getSession() {
        return ServletActionContext.getRequest().getSession();
    }

    public static javax.servlet.ServletContext getServletContext() {
        return ServletActionContext.getRequest().getServletContext();
    }

    public static class ServletContext {
        public static void put(String key, Object value) {
            ServletActionContext.getServletContext().setAttribute(key, value);
        }

        public static <T> T get(String key) {
            return (T)ServletActionContext.getServletContext().getAttribute(key);
        }

        public static void remove(String key) {
            ServletActionContext.getServletContext().removeAttribute(key);
        }

        public static Map<String, Object> getAll() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration names = ServletActionContext.getServletContext().getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                map.put(name, ServletActionContext.getServletContext().getAttribute(name));
            }
            return map;
        }
    }

    public static class Cookie {
        public static void put(String key, Object value) {
            String strValue = CodecUtil.encodeURL(CastUtil.castString(value));
            javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(key, strValue);
            ServletActionContext.getResponse().addCookie(cookie);
        }

        public static <T> T get(String key) {
            String value = null;
            Object[] cookieArray = ServletActionContext.getRequest().getCookies();
            if (ArrayUtil.isNotEmpty(cookieArray)) {
                for (Object cookie : cookieArray) {
                    if (!key.equals(cookie.getName())) continue;
                    value = CodecUtil.decodeURL(cookie.getValue());
                    break;
                }
            }
            return (T)value;
        }

        public static Map<String, Object> getAll() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Object[] cookieArray = ServletActionContext.getRequest().getCookies();
            if (ArrayUtil.isNotEmpty(cookieArray)) {
                for (Object cookie : cookieArray) {
                    map.put(cookie.getName(), cookie.getValue());
                }
            }
            return map;
        }
    }

    public static class Session {
        public static void put(String key, Object value) {
            ServletActionContext.getSession().setAttribute(key, value);
        }

        public static <T> T get(String key) {
            return (T)ServletActionContext.getSession().getAttribute(key);
        }

        public static void remove(String key) {
            ServletActionContext.getSession().removeAttribute(key);
        }

        public static Map<String, Object> getAll() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration names = ServletActionContext.getSession().getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                map.put(name, ServletActionContext.getSession().getAttribute(name));
            }
            return map;
        }

        public static void removeAll() {
            ServletActionContext.getSession().invalidate();
        }
    }

    public static class Response {
        public static void put(String key, Object value) {
            ServletActionContext.getResponse().setHeader(key, CastUtil.castString(value));
        }

        public static <T> T get(String key) {
            return (T)ServletActionContext.getResponse().getHeader(key);
        }

        public static Map<String, Object> getAll() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String name : ServletActionContext.getResponse().getHeaderNames()) {
                map.put(name, ServletActionContext.getResponse().getHeader(name));
            }
            return map;
        }
    }

    public static class Request {
        public static void put(String key, Object value) {
            ServletActionContext.getRequest().setAttribute(key, value);
        }

        public static <T> T get(String key) {
            return (T)ServletActionContext.getRequest().getAttribute(key);
        }

        public static void remove(String key) {
            ServletActionContext.getRequest().removeAttribute(key);
        }

        public static Map<String, Object> getAll() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration names = ServletActionContext.getRequest().getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                map.put(name, ServletActionContext.getRequest().getAttribute(name));
            }
            return map;
        }
    }
}

