/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.mvc;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beetlframework.mvc.ServletActionContext;
import org.beetlframework.util.BeanUtil;

public class RequestParam {
    public static String getParam(String name) {
        return ServletActionContext.getRequest().getParameter(name);
    }

    public static String getPara(String name, String defaultValue) {
        String result = RequestParam.getParam(name);
        return result != null && !"".equals(result) ? result : defaultValue;
    }

    public static Map<String, String[]> getParaMap() {
        return ServletActionContext.getRequest().getParameterMap();
    }

    public static Enumeration<String> getParaNames() {
        return ServletActionContext.getRequest().getParameterNames();
    }

    public static String[] getParaValues(String name) {
        return ServletActionContext.getRequest().getParameterValues(name);
    }

    public static Integer[] getParaValuesToInt(String name) {
        String[] values = ServletActionContext.getRequest().getParameterValues(name);
        if (values == null) {
            return null;
        }
        Integer[] result = new Integer[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(values[i]);
        }
        return result;
    }

    public static Long[] getParaValuesToLong(String name) {
        String[] values = ServletActionContext.getRequest().getParameterValues(name);
        if (values == null) {
            return null;
        }
        Long[] result = new Long[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Long.parseLong(values[i]);
        }
        return result;
    }

    public static Enumeration<String> getAttrNames() {
        return ServletActionContext.getRequest().getAttributeNames();
    }

    public static <T> T getAttr(String name) {
        return (T)ServletActionContext.getRequest().getAttribute(name);
    }

    public static Integer getAttrForInt(String name) {
        return (Integer)ServletActionContext.getRequest().getAttribute(name);
    }

    private static Boolean toBoolean(String value, Boolean defaultValue) {
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        if ("1".equals(value = value.trim().toLowerCase()) || "true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("0".equals(value) || "false".equals(value)) {
            return Boolean.FALSE;
        }
        throw new RuntimeException("\u53c2\u6570\u8f6c\u6362\u4e3aBoolean\u7c7b\u578b\u5931\u8d25");
    }

    public static Boolean getParaToBoolean(String name) {
        return RequestParam.toBoolean(ServletActionContext.getRequest().getParameter(name), null);
    }

    public static String getAttrForStr(String name) {
        return (String)ServletActionContext.getRequest().getAttribute(name);
    }

    public static Integer getIntParam(String name) {
        String str = RequestParam.getParam(name);
        return Integer.parseInt(str);
    }

    public static Integer getIntParam(String name, Integer defaultValue) {
        Integer result = null;
        try {
            result = RequestParam.getIntParam(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result != null ? result : defaultValue;
    }

    public static Long getLongParam(String name) {
        String str = RequestParam.getParam(name);
        return Long.parseLong(str);
    }

    public static Long getLongParam(String name, Long defaultValue) {
        Long result = null;
        try {
            result = RequestParam.getLongParam(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result != null ? result : defaultValue;
    }

    public static void setAttr(String name, Object value) {
        ServletActionContext.getRequest().setAttribute(name, value);
    }

    public static void removeAttr(String name) {
        ServletActionContext.getRequest().removeAttribute(name);
    }

    public static void setAttrs(Map<String, Object> attrMap) {
        HttpServletRequest request = ServletActionContext.getRequest();
        for (Map.Entry<String, Object> entry : attrMap.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public static boolean isParaBlank(String paraName) {
        HttpServletRequest request = ServletActionContext.getRequest();
        String value = request.getParameter(paraName);
        return value == null || value.trim().length() == 0;
    }

    public static boolean isParaExists(String paraName) {
        HttpServletRequest request = ServletActionContext.getRequest();
        return request.getParameterMap().containsKey(paraName);
    }

    private static Date toDate(String value, Date defaultValue) {
        try {
            if (value == null || "".equals(value.trim())) {
                return defaultValue;
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(value.trim());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }

    public static Date getParaToDate(String name) {
        HttpServletRequest request = ServletActionContext.getRequest();
        return RequestParam.toDate(request.getParameter(name), null);
    }

    public static Date getParaToDate(String name, Date defaultValue) {
        HttpServletRequest request = ServletActionContext.getRequest();
        return RequestParam.toDate(request.getParameter(name), defaultValue);
    }

    public static String getCookie(String name, String defaultValue) {
        Cookie cookie = RequestParam.getCookieObject(name);
        return cookie != null ? cookie.getValue() : defaultValue;
    }

    public static String getCookie(String name) {
        return RequestParam.getCookie(name, null);
    }

    public static Integer getCookieToInt(String name) {
        String result = RequestParam.getCookie(name);
        return result != null ? Integer.valueOf(Integer.parseInt(result)) : null;
    }

    public static Integer getCookieToInt(String name, Integer defaultValue) {
        String result = RequestParam.getCookie(name);
        return result != null ? Integer.parseInt(result) : defaultValue;
    }

    public static Long getCookieToLong(String name) {
        String result = RequestParam.getCookie(name);
        return result != null ? Long.valueOf(Long.parseLong(result)) : null;
    }

    public static Long getCookieToLong(String name, Long defaultValue) {
        String result = RequestParam.getCookie(name);
        return result != null ? Long.parseLong(result) : defaultValue;
    }

    public static Cookie getCookieObject(String name) {
        HttpServletRequest request = ServletActionContext.getRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Cookie[] getCookieObjects() {
        HttpServletRequest request = ServletActionContext.getRequest();
        Cookie[] result = request.getCookies();
        return result != null ? result : new Cookie[]{};
    }

    public static void setCookie(Cookie cookie) {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.addCookie(cookie);
    }

    public static void setCookie(String name, String value, int maxAgeInSeconds, String path) {
        RequestParam.setCookie(name, value, maxAgeInSeconds, path, null);
    }

    public static void setCookie(String name, String value, int maxAgeInSeconds, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path);
        HttpServletResponse response = ServletActionContext.getResponse();
        response.addCookie(cookie);
    }

    public static void setCookie(String name, String value, int maxAgeInSeconds) {
        RequestParam.setCookie(name, value, maxAgeInSeconds, "/", null);
    }

    public static void removeCookie(String name) {
        RequestParam.setCookie(name, null, 0, "/", null);
    }

    public static void removeCookie(String name, String path) {
        RequestParam.setCookie(name, null, 0, path, null);
    }

    public static void removeCookie(String name, String path, String domain) {
        RequestParam.setCookie(name, null, 0, path, domain);
    }

    public static <T> T getBean(Class<T> t) {
        HttpServletRequest request = ServletActionContext.getRequest();
        return BeanUtil.getBean(request, t);
    }
}

