/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.mvc;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.beetlframework.FrameworkConstant;
import org.beetlframework.annotation.mvc.Action;
import org.beetlframework.annotation.mvc.Controller;
import org.beetlframework.core.ClassHelper;
import org.beetlframework.mvc.Handler;
import org.beetlframework.mvc.Requestor;
import org.beetlframework.util.ArrayUtil;
import org.beetlframework.util.CollectionUtil;
import org.beetlframework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionMapping {
    private static final Logger logger;
    private static final Map<Requestor, Handler> actionMap;

    private static void println(Map<Requestor, Handler> actionMap) {
        logger.debug("=============action\u6620\u5c04\u5f00\u59cb=================");
        String msg = String.format("url           ==> \u5168\u7c7b\u540d.\u65b9\u6cd5\u540d()", new Object[0]);
        logger.debug(msg);
        logger.debug("--------------------------------------------");
        Set<Requestor> set = actionMap.keySet();
        for (Requestor k : set) {
            String message = String.format("@%s(%s) ==> %s.%s", k.getRequestMethod(), k.getRequestPath(), actionMap.get(k).getActionClass(), actionMap.get(k).getActionMethod().getName() + "()");
            logger.debug(message);
        }
        logger.debug("=============action\u6620\u5c04\u7ed3\u675f=================");
    }

    private static boolean checkActionMap(Method actionMethod, Map<Requestor, Handler> commonActionMap, Map<Requestor, Handler> regexpActionMap) {
        if (FrameworkConstant.DEV_MODE) {
            if (!actionMethod.isAnnotationPresent(Action.class)) {
                return false;
            }
            String requestPath = actionMethod.getAnnotation(Action.class).value();
            Set<Requestor> set = commonActionMap.keySet();
            for (Requestor req : set) {
                if (!req.getRequestPath().equalsIgnoreCase(requestPath)) continue;
                return true;
            }
            set = regexpActionMap.keySet();
            for (Requestor req : set) {
                if (!req.getRequestPath().equalsIgnoreCase(requestPath)) continue;
                return true;
            }
        }
        return false;
    }

    private static void handleActionMethod(Class<?> actionClass, Method actionMethod, Map<Requestor, Handler> commonActionMap, Map<Requestor, Handler> regexpActionMap) {
        if (actionMethod.isAnnotationPresent(Action.class)) {
            String requestPath = actionMethod.getAnnotation(Action.class).value();
            ActionMapping.putActionMap("Action", requestPath, actionClass, actionMethod, commonActionMap, regexpActionMap);
        }
    }

    private static void putActionMap(String requestMethod, String requestPath, Class<?> actionClass, Method actionMethod, Map<Requestor, Handler> commonActionMap, Map<Requestor, Handler> regexpActionMap) {
        if (requestPath.matches(".+\\{\\w+\\}.*")) {
            requestPath = StringUtil.replaceAll(requestPath, "\\{\\w+\\}", "(\\\\w+)");
            regexpActionMap.put(new Requestor(requestMethod, requestPath), new Handler(actionClass, actionMethod));
        } else {
            commonActionMap.put(new Requestor(requestMethod, requestPath), new Handler(actionClass, actionMethod));
        }
    }

    public static Map<Requestor, Handler> getActionMap() {
        return actionMap;
    }

    static {
        List<Class<?>> ctrlNameSuffixClassList;
        logger = LoggerFactory.getLogger(ActionMapping.class);
        actionMap = new LinkedHashMap<Requestor, Handler>();
        List<Class<?>> ctrlAnnotationClassList = ClassHelper.getClassListByAnnotation(Controller.class);
        List controllerClassList = (List)CollectionUtils.union(ctrlAnnotationClassList, ctrlNameSuffixClassList = ClassHelper.getClassListByNameSuffix("Controller"));
        if (CollectionUtil.isNotEmpty(controllerClassList)) {
            HashMap<Requestor, Handler> commonActionMap = new HashMap<Requestor, Handler>();
            HashMap<Requestor, Handler> regexpActionMap = new HashMap<Requestor, Handler>();
            for (Class actionClass : controllerClassList) {
                Object[] actionMethods = actionClass.getDeclaredMethods();
                if (!ArrayUtil.isNotEmpty(actionMethods)) continue;
                for (Object actionMethod : actionMethods) {
                    if (ActionMapping.checkActionMap((Method)actionMethod, commonActionMap, regexpActionMap)) {
                        String message = String.format("Action\u6620\u5c04\u51b2\u7a81:%s", ((Method)actionMethod).getAnnotation(Action.class).value());
                        throw new RuntimeException(message);
                    }
                    ActionMapping.handleActionMethod(actionClass, (Method)actionMethod, commonActionMap, regexpActionMap);
                }
            }
            actionMap.putAll(commonActionMap);
            actionMap.putAll(regexpActionMap);
            if (FrameworkConstant.DEV_MODE) {
                ActionMapping.println(actionMap);
            }
        }
    }
}

