/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.ioc;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.beetlframework.annotation.ioc.Impl;
import org.beetlframework.annotation.ioc.Inject;
import org.beetlframework.core.ClassHelper;
import org.beetlframework.fault.InitializationError;
import org.beetlframework.ioc.BeanContext;
import org.beetlframework.util.ArrayUtil;
import org.beetlframework.util.CollectionUtil;

public class IocHelper {
    public static Class<?> findImplementClass(Class<?> interfaceClass) {
        Class<?> implementClass = interfaceClass;
        if (interfaceClass.isAnnotationPresent(Impl.class)) {
            implementClass = interfaceClass.getAnnotation(Impl.class).value();
        } else {
            List<Class<?>> implementClassList = ClassHelper.getClassListBySuper(interfaceClass);
            if (CollectionUtil.isNotEmpty(implementClassList)) {
                implementClass = implementClassList.get(0);
            }
        }
        return implementClass;
    }

    static {
        try {
            Map<Class<?>, Object> beanMap = BeanContext.getBeanMap();
            for (Map.Entry<Class<?>, Object> beanEntry : beanMap.entrySet()) {
                Class<?> beanClass = beanEntry.getKey();
                Object beanInstance = beanEntry.getValue();
                Object[] beanFields = beanClass.getDeclaredFields();
                if (!ArrayUtil.isNotEmpty(beanFields)) continue;
                for (Object beanField : beanFields) {
                    Class<?> interfaceClass;
                    Class<?> implementClass;
                    if (!((AccessibleObject)beanField).isAnnotationPresent(Inject.class) || (implementClass = IocHelper.findImplementClass(interfaceClass = ((Field)beanField).getType())) == null) continue;
                    Object implementInstance = beanMap.get(implementClass);
                    if (implementInstance != null) {
                        ((Field)beanField).setAccessible(true);
                        ((Field)beanField).set(beanInstance, implementInstance);
                        continue;
                    }
                    throw new InitializationError("\u4f9d\u8d56\u6ce8\u5165\u5931\u8d25\uff01\u7c7b\u540d\uff1a" + beanClass.getSimpleName() + "\uff0c\u5b57\u6bb5\u540d\uff1a" + interfaceClass.getSimpleName());
                }
            }
        }
        catch (Exception e) {
            throw new InitializationError("\u521d\u59cb\u5316 IocHelper \u51fa\u9519\uff01", e);
        }
    }
}

