/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.ioc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetlframework.annotation.aop.Aspect;
import org.beetlframework.annotation.ioc.Bean;
import org.beetlframework.annotation.mvc.Controller;
import org.beetlframework.annotation.tx.Service;
import org.beetlframework.core.ClassHelper;
import org.beetlframework.fault.InitializationError;

public class BeanContext {
    private static final Map<Class<?>, Object> beanMap = new HashMap();

    private static void init() {
        try {
            List<Class<?>> classList = ClassHelper.getClassList();
            for (Class<?> cls : classList) {
                if (!cls.isAnnotationPresent(Bean.class) && !cls.isAnnotationPresent(Service.class) && !cls.isAnnotationPresent(Controller.class) && !cls.getName().endsWith("Controller") && !cls.isAnnotationPresent(Aspect.class)) continue;
                Object beanInstance = cls.newInstance();
                beanMap.put(cls, beanInstance);
            }
        }
        catch (Exception e) {
            throw new InitializationError("\u521d\u59cb\u5316 BeanHelper \u51fa\u9519\uff01", e);
        }
    }

    public static Map<Class<?>, Object> getBeanMap() {
        return beanMap;
    }

    public static <T> T getBean(Class<T> cls) {
        if (!beanMap.containsKey(cls)) {
            throw new RuntimeException("\u65e0\u6cd5\u6839\u636e\u7c7b\u540d\u83b7\u53d6\u5b9e\u4f8b\uff01" + cls);
        }
        return (T)beanMap.get(cls);
    }

    public static void setBean(Class<?> cls, Object obj) {
        beanMap.put(cls, obj);
    }

    static {
        BeanContext.init();
    }
}

