/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.core.impl.support;

import java.io.File;
import java.io.FileFilter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.beetlframework.util.ClassLoaderUtil;
import org.beetlframework.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassTemplate {
    private static final Logger logger = LoggerFactory.getLogger(ClassTemplate.class);
    protected final String packageName;

    protected ClassTemplate(String packageName) {
        this.packageName = packageName;
    }

    public final List<Class<?>> getClassList() {
        ArrayList classList = new ArrayList();
        try {
            Enumeration<URL> urls = ClassLoaderUtil.getClassLoader().getResources(this.packageName.replace(".", "/"));
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if (protocol.equals("file")) {
                    String packagePath = url.getPath();
                    this.addClass(classList, packagePath, this.packageName);
                    continue;
                }
                if (!protocol.equals("jar")) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(".class")) continue;
                    String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                    this.doAddClass(classList, className);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7c7b\u51fa\u9519\uff01", (Throwable)e);
        }
        return classList;
    }

    private void addClass(List<Class<?>> classList, String packagePath, String packageName) {
        try {
            File[] files;
            for (File file : files = new File(packagePath).listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".class") || file.isDirectory();
                }
            })) {
                String fileName = file.getName();
                if (file.isFile()) {
                    String className = fileName.substring(0, fileName.lastIndexOf("."));
                    if (StringUtil.isNotEmpty(packageName)) {
                        className = packageName + "." + className;
                    }
                    this.doAddClass(classList, className);
                    continue;
                }
                String subPackagePath = fileName;
                if (StringUtil.isNotEmpty(packagePath)) {
                    subPackagePath = packagePath + "/" + subPackagePath;
                }
                String subPackageName = fileName;
                if (StringUtil.isNotEmpty(packageName)) {
                    subPackageName = packageName + "." + subPackageName;
                }
                this.addClass(classList, subPackagePath, subPackageName);
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u7c7b\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    private void doAddClass(List<Class<?>> classList, String className) {
        Class<?> cls = ClassLoaderUtil.loadClass(className, false);
        if (this.checkAddClass(cls)) {
            classList.add(cls);
        }
    }

    public abstract boolean checkAddClass(Class<?> var1);
}

