/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.core.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import org.beetlframework.core.ClassScanner;
import org.beetlframework.core.impl.support.AnnotationClassTemplate;
import org.beetlframework.core.impl.support.ClassTemplate;
import org.beetlframework.core.impl.support.SuffixClassTemplate;
import org.beetlframework.core.impl.support.SupperClassTemplate;

public class DefaultClassScanner
implements ClassScanner {
    @Override
    public List<Class<?>> getClassList(String packageName) {
        return new ClassTemplate(packageName){

            @Override
            public boolean checkAddClass(Class<?> cls) {
                String className = cls.getName();
                String pkgName = className.substring(0, className.lastIndexOf("."));
                return pkgName.startsWith(this.packageName);
            }
        }.getClassList();
    }

    @Override
    public List<Class<?>> getClassListByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return new AnnotationClassTemplate(packageName, annotationClass){

            @Override
            public boolean checkAddClass(Class<?> cls) {
                return cls.isAnnotationPresent(this.annotationClass);
            }
        }.getClassList();
    }

    @Override
    public List<Class<?>> getClassListBySuper(String packageName, Class<?> superClass) {
        return new SupperClassTemplate(packageName, superClass){

            @Override
            public boolean checkAddClass(Class<?> cls) {
                return this.superClass.isAssignableFrom(cls) && !this.superClass.equals(cls);
            }
        }.getClassList();
    }

    @Override
    public List<Class<?>> getClassListByNameSuffix(String packageName, String suffix) {
        return new SuffixClassTemplate(packageName, suffix){

            @Override
            public boolean checkAddClass(Class<?> cls) {
                return cls.getName().endsWith(this.suffix);
            }
        }.getClassList();
    }
}

