/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework.aop;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.beetlframework.InstanceFactory;
import org.beetlframework.annotation.aop.Aspect;
import org.beetlframework.annotation.aop.AspectOrder;
import org.beetlframework.aop.AspectProxy;
import org.beetlframework.aop.proxy.Proxy;
import org.beetlframework.aop.proxy.ProxyManager;
import org.beetlframework.core.ClassHelper;
import org.beetlframework.core.ClassScanner;
import org.beetlframework.fault.InitializationError;
import org.beetlframework.ioc.BeanContext;
import org.beetlframework.plugin.PluginProxy;
import org.beetlframework.util.ClassLoaderUtil;
import org.beetlframework.util.CollectionUtil;
import org.beetlframework.util.StringUtil;

public class AopHelper {
    private static final ClassScanner classScanner = InstanceFactory.getClassScanner();

    private static Map<Class<?>, List<Class<?>>> createProxyMap() throws Exception {
        LinkedHashMap proxyMap = new LinkedHashMap();
        AopHelper.addPluginProxy(proxyMap);
        AopHelper.addAspectProxy(proxyMap);
        AopHelper.addTransactionProxy(proxyMap);
        return proxyMap;
    }

    private static void addPluginProxy(Map<Class<?>, List<Class<?>>> proxyMap) throws Exception {
        List<Class<?>> pluginProxyClassList = classScanner.getClassListBySuper("org.beetl.plugin", PluginProxy.class);
        if (CollectionUtil.isNotEmpty(pluginProxyClassList)) {
            for (Class<?> pluginProxyClass : pluginProxyClassList) {
                PluginProxy pluginProxy = (PluginProxy)pluginProxyClass.newInstance();
                proxyMap.put(pluginProxyClass, pluginProxy.getTargetClassList());
            }
        }
    }

    private static void addAspectProxy(Map<Class<?>, List<Class<?>>> proxyMap) throws Exception {
        List<Class<?>> aspectProxyClassList = ClassHelper.getClassListBySuper(AspectProxy.class);
        aspectProxyClassList.addAll(classScanner.getClassListBySuper("org.beetl.plugin", AspectProxy.class));
        AopHelper.sortAspectProxyClassList(aspectProxyClassList);
        for (Class<?> aspectProxyClass : aspectProxyClassList) {
            if (!aspectProxyClass.isAnnotationPresent(Aspect.class)) continue;
            Aspect aspect = aspectProxyClass.getAnnotation(Aspect.class);
            List<Class<?>> targetClassList = AopHelper.createTargetClassList(aspect);
            proxyMap.put(aspectProxyClass, targetClassList);
        }
    }

    private static void addTransactionProxy(Map<Class<?>, List<Class<?>>> proxyMap) {
    }

    private static void sortAspectProxyClassList(List<Class<?>> proxyClassList) {
        Collections.sort(proxyClassList, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> aspect1, Class<?> aspect2) {
                if (aspect1.isAnnotationPresent(AspectOrder.class) || aspect2.isAnnotationPresent(AspectOrder.class)) {
                    if (aspect1.isAnnotationPresent(AspectOrder.class)) {
                        return this.getOrderValue(aspect1) - this.getOrderValue(aspect2);
                    }
                    return this.getOrderValue(aspect2) - this.getOrderValue(aspect1);
                }
                return aspect1.hashCode() - aspect2.hashCode();
            }

            private int getOrderValue(Class<?> aspect) {
                return aspect.getAnnotation(AspectOrder.class) != null ? aspect.getAnnotation(AspectOrder.class).value() : 0;
            }
        });
    }

    private static List<Class<?>> createTargetClassList(Aspect aspect) throws Exception {
        ArrayList targetClassList = new ArrayList();
        String pkg = aspect.pkg();
        String cls = aspect.cls();
        Class<? extends Annotation> annotation = aspect.annotation();
        if (StringUtil.isNotEmpty(pkg)) {
            if (StringUtil.isNotEmpty(cls)) {
                targetClassList.add(ClassLoaderUtil.loadClass(pkg + "." + cls, false));
            } else if (annotation != null && !annotation.equals(Aspect.class)) {
                targetClassList.addAll(classScanner.getClassListByAnnotation(pkg, annotation));
            } else {
                targetClassList.addAll(classScanner.getClassList(pkg));
            }
        } else if (annotation != null && !annotation.equals(Aspect.class)) {
            targetClassList.addAll(ClassHelper.getClassListByAnnotation(annotation));
        }
        return targetClassList;
    }

    private static Map<Class<?>, List<Proxy>> createTargetMap(Map<Class<?>, List<Class<?>>> proxyMap) throws Exception {
        HashMap targetMap = new HashMap();
        for (Map.Entry<Class<?>, List<Class<?>>> proxyEntry : proxyMap.entrySet()) {
            Class<?> proxyClass = proxyEntry.getKey();
            List<Class<?>> targetClassList = proxyEntry.getValue();
            for (Class<?> targetClass : targetClassList) {
                Proxy baseAspect = (Proxy)proxyClass.newInstance();
                if (targetMap.containsKey(targetClass)) {
                    ((List)targetMap.get(targetClass)).add(baseAspect);
                    continue;
                }
                ArrayList<Proxy> baseAspectList = new ArrayList<Proxy>();
                baseAspectList.add(baseAspect);
                targetMap.put(targetClass, baseAspectList);
            }
        }
        return targetMap;
    }

    static {
        try {
            Map<Class<?>, List<Class<?>>> proxyMap = AopHelper.createProxyMap();
            Map<Class<?>, List<Proxy>> targetMap = AopHelper.createTargetMap(proxyMap);
            for (Map.Entry<Class<?>, List<Proxy>> targetEntry : targetMap.entrySet()) {
                Class<?> targetClass = targetEntry.getKey();
                List<Proxy> proxyList = targetEntry.getValue();
                Object proxyInstance = ProxyManager.createProxy(targetClass, proxyList);
                BeanContext.setBean(targetClass, proxyInstance);
            }
        }
        catch (Exception e) {
            throw new InitializationError("\u521d\u59cb\u5316 AopHelper \u51fa\u9519\uff01", e);
        }
    }
}

