/*
 * Decompiled with CFR 0.152.
 */
package org.beetlframework;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetlframework.core.ClassScanner;
import org.beetlframework.core.ConfigHelper;
import org.beetlframework.core.impl.DefaultClassScanner;
import org.beetlframework.mvc.HandlerExceptionResolver;
import org.beetlframework.mvc.HandlerInvoker;
import org.beetlframework.mvc.HandlerMapping;
import org.beetlframework.mvc.ViewResolver;
import org.beetlframework.mvc.impl.BeetlHandlerInvoker;
import org.beetlframework.mvc.impl.BeetlViewResolver;
import org.beetlframework.mvc.impl.DefaultHandlerExceptionResolver;
import org.beetlframework.mvc.impl.DefaultHandlerMapping;
import org.beetlframework.util.ObjectUtil;
import org.beetlframework.util.StringUtil;

public class InstanceFactory {
    private static final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private static final String CLASS_SCANNER = "beetl.framework.custom.class_scanner";
    private static final String HANDLER_MAPPING = "beetl.framework.custom.handler_mapping";
    private static final String HANDLER_INVOKER = "beetl.framework.custom.handler_invoker";
    private static final String HANDLER_EXCEPTION_RESOLVER = "beetl.framework.custom.handler_exception_resolver";
    private static final String VIEW_RESOLVER = "beetl.framework.custom.view_resolver";

    public static ClassScanner getClassScanner() {
        return InstanceFactory.getInstance(CLASS_SCANNER, DefaultClassScanner.class);
    }

    public static HandlerMapping getHandlerMapping() {
        return InstanceFactory.getInstance(HANDLER_MAPPING, DefaultHandlerMapping.class);
    }

    public static HandlerInvoker getHandlerInvoker() {
        return InstanceFactory.getInstance(HANDLER_INVOKER, BeetlHandlerInvoker.class);
    }

    public static HandlerExceptionResolver getHandlerExceptionResolver() {
        return InstanceFactory.getInstance(HANDLER_EXCEPTION_RESOLVER, DefaultHandlerExceptionResolver.class);
    }

    public static ViewResolver getViewResolver() {
        return InstanceFactory.getInstance(VIEW_RESOLVER, BeetlViewResolver.class);
    }

    public static <T> T getInstance(String cacheKey, Class<T> defaultImplClass) {
        Object instance;
        if (cache.containsKey(cacheKey)) {
            return (T)cache.get(cacheKey);
        }
        String implClassName = ConfigHelper.getString(cacheKey);
        if (StringUtil.isEmpty(implClassName)) {
            implClassName = defaultImplClass.getName();
        }
        if ((instance = ObjectUtil.newInstance(implClassName)) != null) {
            cache.put(cacheKey, instance);
        }
        return instance;
    }
}

