/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.plugin.i18n;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.beetlframework.FrameworkConstant;
import org.beetlframework.plugin.Plugin;
import org.beetlframework.util.ArrayUtil;
import org.beetlframework.util.ClassLoaderUtil;
import org.beetlframework.util.FileUtil;
import org.beetlframework.util.JsonUtil;
import org.beetlframework.util.PropsUtil;

public class I18NPlugin
implements Plugin {
    @Override
    public void init() {
        String appBasePath = ClassLoaderUtil.getClassPath() + "../../";
        I18NPlugin.generateJS(appBasePath);
    }

    @Override
    public void destroy() {
    }

    public static void generateJS(String appBasePath) {
        Object[] propsFileNames;
        String propsBasePath = appBasePath + "/WEB-INF/classes/" + "i18n/";
        String jsBasePath = appBasePath + FrameworkConstant.WWW_PATH + "i18n/";
        File propsBaseDir = new File(propsBasePath);
        if (propsBaseDir.exists() && ArrayUtil.isNotEmpty(propsFileNames = propsBaseDir.list())) {
            for (Object propsFileName : propsFileNames) {
                String jsFilePath = jsBasePath + ((String)propsFileName).substring(0, ((String)propsFileName).lastIndexOf(".")) + ".js";
                HashMap<String, String> map = new HashMap<String, String>();
                Properties props = PropsUtil.loadProps("i18n/" + (String)propsFileName);
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = props.getProperty(name);
                    map.put(name, value);
                }
                String jsFileContent = "window.I18N = " + JsonUtil.toJSON(map) + ";";
                FileUtil.writeFile(jsFilePath, jsFileContent);
            }
        }
    }
}

