/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.plugin.i18n;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.beetl.plugin.i18n.I18NPlugin;
import org.beetlframework.FrameworkConstant;
import org.beetlframework.core.ConfigHelper;
import org.beetlframework.util.ClassLoaderUtil;
import org.beetlframework.util.StringUtil;
import org.beetlframework.util.WebUtil;

@WebFilter(value={"/*"})
public class I18NFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String requestPath = WebUtil.getRequestPath(req);
        if (!requestPath.startsWith(FrameworkConstant.WWW_PATH)) {
            String systemLanguage = I18NFilter.getSystemLanguage((HttpServletRequest)request);
            request.setAttribute("system_language", (Object)systemLanguage);
            boolean reloadable = ConfigHelper.getBoolean("beetl.plugin.i18n.reloadable");
            if (reloadable) {
                ResourceBundle.clearCache();
                String appBasePath = req.getServletContext().getRealPath("");
                I18NPlugin.generateJS(appBasePath);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private static String getSystemLanguage(HttpServletRequest request) {
        String i18nPropsPath;
        File i18nPropsFile;
        String language = WebUtil.getCookie(request, "cookie_language");
        if (StringUtil.isEmpty(language) && StringUtil.isEmpty(language = request.getLocale().toString())) {
            language = Locale.getDefault().toString();
        }
        if (!(i18nPropsFile = new File(i18nPropsPath = ClassLoaderUtil.getClassPath() + "i18n/" + "i18n_" + language + ".properties")).exists()) {
            language = "en_US";
        }
        return language;
    }
}

